package immibis.chunkloader.quota;

import immibis.chunkloader.TileChunkLoader;

import java.util.HashMap;
import java.util.Map;

public abstract class Quota {
	
	public static final int UNLIMITED = -2;
	public abstract int getMaxQuotaFor(String username);
	public void onTick(TileChunkLoader tile) {}
	
	
	
	private static Map<String, Class<? extends Quota>> types = new HashMap<String, Class<? extends Quota>>();

	public static String getAllowedTypesString() {
		String s = "";
		for(String t : types.keySet()) {
			if(!s.equals(""))
				s += ", ";
			s += t;
		}
		return s;
	}

	public static Quota createInstance(String quotaType) {
		Class<? extends Quota> clazz = types.get(quotaType);
		if(clazz == null)
			throw new RuntimeException("Invalid quota type: "+quotaType);
		try {
			return clazz.getConstructor().newInstance();
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	static {
		types.put("unlimited", UnlimitedQuota.class);
		types.put("perplayer", PerPlayerQuota.class);
	}
}
