package immibis.chunkloader.quota;

import immibis.core.Config;
import immibis.core.api.porting.SidedProxy;

public class PerPlayerQuota extends Quota {
	
	public int maxQuota;
	
	public PerPlayerQuota() {
		maxQuota = Config.getInt("chunkloader.perplayer.maxChunksPerPlayer", 9);
	}

	@Override
	public int getMaxQuotaFor(String username) {
		return SidedProxy.instance.isOp(username) ? Quota.UNLIMITED : maxQuota;
	}
}
