package immibis.chunkloader;

import immibis.chunkloader.WorldInfo.LoaderInfo;
import immibis.core.api.porting.SidedProxy;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logging {
	public static PrintWriter logFile = null;
	public static File listFile = null;
	public static String listName = null;
	private static boolean logDirty = true;
	
	public static void openLog(String name) {
		listName = name;
		try {
			logFile = new PrintWriter(new FileWriter(new File(SidedProxy.instance.getMinecraftDir(), name), true));
			log("Log opened");
		} catch(IOException e) {
			throw new RuntimeException("Error opening chunk loader log file "+name, e);
		}
	}
	
	public static void setList(String name) {
		listFile = new File(SidedProxy.instance.getMinecraftDir(), name);
	}
	
	public static void flushLog() {
		if(!logDirty) return;
		logDirty = false;
		
		if(logFile != null)
			logFile.flush();
		
		if(listFile != null) {
			try {
				PrintWriter out = new PrintWriter(new FileWriter(listFile));
				for(WorldInfo wi : DimensionalAnchors.allWorlds())
				{
					out.println("In "+wi.getName()+":");
					for(LoaderInfo l : wi.getAllLoaders())
						out.println("  At " + l.pos + ": " + l.getLogString());
				}
				out.close();
			} catch(IOException e) {
				new RuntimeException("Error writing chunk loader list file "+listName, e).printStackTrace();
			}
		}
	}
	
	private static void log(String s) {
		//ModLoader.getLogger().info(s);
		if(logFile != null)
			logFile.println("[" + getTimestamp() + "] " + s);
		logDirty = true;
	}
	
	private static void writeLog(String action, WorldInfo.LoaderInfo loader, String player) {
		log("Loader "+action+(player != null ? " by "+player : "")+" at "+loader.pos+" in "+loader.world.getName()+", "+loader.getLogString());
	}
	
	public static void onAdded(WorldInfo.LoaderInfo loader, String player) {
		writeLog("added", loader, player);
	}
	
	public static void onChanged(WorldInfo.LoaderInfo loader, String player) {
		writeLog("updated", loader, player);
	}
	
	public static void onRemoved(WorldInfo.LoaderInfo loader, String player) {
		writeLog("removed", loader, player);
	}
	
	public static void onUnloadWorld(WorldInfo wi) {
		log("Unloaded world info for "+wi.getName());
	}
	
	public static void onLoadWorld(WorldInfo wi) {
		log("Loaded world info for "+wi.getName());
	}
	
	private static DateFormat tsFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	public static String getTimestamp() {
		return tsFormat.format(new Date());
	}

	public static void onValidated(LoaderInfo loader, String string) {
		writeLog("validated", loader, null);
	}
	
	public static void onInvalidated(LoaderInfo loader, String string) {
		writeLog("invalidated/removed", loader, null);
	}
}
