package immibis.tubestuff;

import immibis.core.BasicInventory;
import immibis.core.FakeSlotContainer;
import immibis.core.SlotFake;
import immibis.core.api.porting.PortableContainer;
import net.minecraft.src.Container;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.src.Slot;

import static immibis.tubestuff.TileAutoCraftingMk2.*;

public class ContainerAutoCraftingMk2 extends FakeSlotContainer {
	private int invStart;
	
	public ContainerAutoCraftingMk2(EntityPlayer player, IInventory table) {
		super(player, table);
		
		addSlot(new Slot(table, SLOT_OUTPUT, 134, 124));
		for(int x = 0; x < 3; x++)
			for(int y = 0; y < 3; y++)
				addSlot(new SlotFake(table, x + y * 3 + START_RECIPE, x * 18 + 31, y * 18 + 107));
		for(int y = 0; y < 5; y++)
			for(int x = 0; x < 9; x++)
				addSlot(new Slot(table, x + y * 9 + START_INPUT, x * 18 + 13, y * 19 + 6));

		invStart = inventorySlots.size();
		
		for(int x = 0; x < 9; x++)
		{
			for(int y = 0; y < 3; y++)
				addSlot(new Slot(player.inventory, x + y*9 + 9, x * 18 + 13, y * 18 + 168));
			addSlot(new Slot(player.inventory, x, x * 18 + 13, 226));
		}
	}
	
	@Override
	public ItemStack transferStackInSlot(int slot) {
		Slot src = (Slot)inventorySlots.get(slot);
		try
		{
			int slotIndex = (Integer)ModLoader.getPrivateValue(Slot.class, src, 0);
			if(slot < invStart)
			{
				BasicInventory.mergeStackIntoRange(inv, player.inventory, slotIndex, 0, 36);
			}
			else
				BasicInventory.mergeStackIntoRange(player.inventory, inv, slotIndex, START_INPUT, START_INPUT + SIZE_INPUT);
		}
		catch(Exception e)
		{
			return null;
		}
		return null;
	}
}
