package immibis.tubestuff;

import java.util.List;

import immibis.core.BasicInventory;
import immibis.core.porting.PortableContainer;
import net.minecraft.src.*;

public class ContainerInfiniteChest extends PortableContainer {
	public TileInfiniteChest chest;
	public int page;
	
	public static final int WIDTH = 13;
	public static final int HEIGHT = 6;
	
	public void setPage(int page) {
		this.page = page;
		
		int startIndex = page * WIDTH * HEIGHT;
		
		inventorySlots.clear();
		
		for(int y = 0; y < HEIGHT; y++)
			for(int x = 0; x < WIDTH; x++)
				addSlot(new Slot(chest, startIndex + x + y * WIDTH, x*18 + 5, y*18 + 4));
		
		for(int y = 0; y < 3; y++)
			for(int x = 0; x < 9; x++)
				addSlot(new Slot(player.inventory, x + y*9 + 9, x * 18 + 5, y * 18 + 123));
		
		for(int x = 0; x < 9; x++)
			addSlot(new Slot(player.inventory, x, x * 18 + 5, 181));
		
		chest.onInventoryChanged();
	}
	
	public ContainerInfiniteChest(EntityPlayer player, TileInfiniteChest chest) {
		super(player, chest);
		this.chest = chest;
		setPage(0);
	}
	
	public ItemStack slotClick(int i, int j, boolean flag, EntityPlayer entityplayer) {
		if(j == 3)
		{
			// previous page
			if(page > 0)
				setPage(page - 1);
			return null;
		}
		else if(j == 4)
		{
			// next page
			if(page < chest.maxPages - 1)
				setPage(page + 1);
			return null;
		}
		else
		{
			return super.slotClick(i, j, flag, entityplayer);
		}
	}
	
	/* $if client$ */
	@Override
	public void updateProgressBar(int bar, int value) {
		if(bar == 0)
			page = value;
		else if(bar == 1)
			chest.maxPages = value;
	}
	/* $endif$ */
	
	/* $if server$
	@Override
	public void onCraftGuiOpened(ICrafting par1ICrafting)
    {
        super.onCraftGuiOpened(par1ICrafting);
        par1ICrafting.updateCraftingInventoryInfo(this, 0, this.page);
        par1ICrafting.updateCraftingInventoryInfo(this, 1, this.chest.maxPages);
    }
    $endif$ */
	
	private int lastPage = -1, lastMaxPages = -1;

    @Override
    public void updateCraftingResults()
    {
        super.updateCraftingResults();

        for(ICrafting var2 : (List<ICrafting>)crafters)
        {
            if(lastPage != page)
                var2.updateCraftingInventoryInfo(this, 0, page);
            
            if(lastMaxPages != chest.maxPages)
            	var2.updateCraftingInventoryInfo(this, 1, chest.maxPages);
        }
        
        this.lastPage = page;
        this.lastMaxPages = chest.maxPages;
    }
	
	@Override
	public ItemStack transferStackInSlot(int slotIndex) {
		Slot slot = (Slot)inventorySlots.get(slotIndex);
		if(slot == null)
			return null;
		
		try
		{
			int invSlot = (Integer)ModLoader.getPrivateValue(Slot.class, slot, 0);
			if(slot.inventory == player)
				BasicInventory.mergeStackIntoRange(player.inventory, chest, invSlot, 0, chest.items.size() + 1);
			else if(slot.inventory == chest)
				BasicInventory.mergeStackIntoRange(chest, player.inventory, invSlot, 0, 36);
			return null;
		}
		catch(Exception e)
		{
			return null;
		}
	}
	
}
