package mods.immibis.redlogic.chips.ingame;

import java.util.List;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.immibis.redlogic.RedLogicMod;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class ItemChip extends Item {

	public ItemChip(int idm256) {
		super(idm256);
		
		setMaxStackSize(64);
		setUnlocalizedName("redlogic.custom-circuit");
		setTextureName("redlogic:chip");
	}
	
	public static String getClassName(ItemStack stack) {
		if(stack.itemID != RedLogicMod.chipItem.itemID)
			return null;
		if(!stack.hasTagCompound())
			return null;
		if(!stack.stackTagCompound.hasKey("classname"))
			return null;
		return stack.stackTagCompound.getString("classname");
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	@SideOnly(Side.CLIENT)
	public void addInformation(ItemStack stack, EntityPlayer ply, List lines, boolean showIDs) {
		super.addInformation(stack, ply, lines, showIDs);
		
		if(showIDs) {
			lines.add("Class name:");
			String n = getClassName(stack);
			int chunksize = 30;
			for(int st = 0; st < n.length(); st += chunksize)
				lines.add(n.substring(st, Math.min(st+chunksize, n.length())));
		}
	}

	public static ItemStack createItemStack(String className) {
		ItemStack st = new ItemStack(RedLogicMod.chipItem);
		st.stackTagCompound = new NBTTagCompound("tag");
		st.stackTagCompound.setString("classname", className);
		return st;
	}
	
	@Override
	public boolean onItemUse(ItemStack stack, EntityPlayer ply, World w, int x, int y, int z, int side, float subX, float subY, float subZ) {
		int oldID = w.getBlockId(x, y, z);
		if(Block.blocksList[oldID] == null || Block.blocksList[oldID].isBlockReplaceable(w, x, y, z)) {
			// replace this block
		} else {
			ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[side];
			x += fd.offsetX; y += fd.offsetY; z += fd.offsetZ;
			
			if(!w.isAirBlock(x, y, z))
				return false; // can't place here
		}
		
		w.setBlock(x, y, z, RedLogicMod.customCircuitBlock.blockID, 0, 0);
		if(w.getBlockId(x, y, z) == RedLogicMod.customCircuitBlock.blockID) {
			((TileCustomCircuit)w.getBlockTileEntity(x, y, z)).init(getClassName(stack));
			stack.stackSize--;
		}
		
		return true;
	}

}
