package mods.immibis.redlogic.wires;


import java.util.List;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

import mods.immibis.core.api.multipart.util.BlockMultipartBase;
import mods.immibis.core.api.porting.SidedProxy;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WireBlock extends BlockMultipartBase {
	
	private int renderType = SidedProxy.instance.getUniqueBlockModelID("mods.immibis.redlogic.wires.StaticRenderer", true);

	public WireBlock(int id) {
		super(id, Material.circuits);
		setCreativeTab(CreativeTabs.tabRedstone);
	}
	
	@Override
	@SideOnly(Side.CLIENT)
	public void registerIcons(IconRegister reg) {
		for(EnumWires wireType : EnumWires.VALUES)
			wireType.texture = reg.registerIcon(wireType.textureName);
	}
	
	@Override
	public int wrappedGetRenderType() {
		return renderType;
	}
	
	@Override
	public void getSubBlocks(int par1, CreativeTabs par2CreativeTabs, List par3List) {
		for(EnumWires type : EnumWires.VALUES)
			par3List.add(new ItemStack(this, 1, type.ordinal()));
	}
	
	@Override
	public TileEntity createTileEntity(World world, int meta) {
		try {
			return EnumWires.VALUES[meta].teclass.getConstructor().newInstance();
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	@Override
	public TileEntity createNewTileEntity(World world) {
		return null;
	}
	
	@Override
	public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
		((WireTile)par1World.getBlockTileEntity(par2, par3, par4)).onNeighbourBlockChange();
	}
	
	@Override
	public int isProvidingStrongPower(IBlockAccess w, int x, int y, int z, int opposite_dir) {
		if(w.getBlockMetadata(x, y, z) != EnumWires.RED_ALLOY.ordinal())
			return 0;
		
		RedAlloyTile tile = ((RedAlloyTile)w.getBlockTileEntity(x, y, z));
		
		return tile.isProvidingStrongPower(opposite_dir ^ 1) ? tile.getVanillaRedstoneStrength() : 0;
	}
	
	@Override
	public int isProvidingWeakPower(IBlockAccess w, int x, int y, int z, int opposite_dir) {
		if(w.getBlockMetadata(x, y, z) != EnumWires.RED_ALLOY.ordinal())
			return 0;
		
		RedAlloyTile tile = ((RedAlloyTile)w.getBlockTileEntity(x, y, z));
		
		return tile.isProvidingWeakPower(opposite_dir ^ 1) ? tile.getVanillaRedstoneStrength() : 0;
	}
	
	@Override
	public boolean canProvidePower() {
		return true;
	}
	
}
