package mods.immibis.redlogic.gates;

import mods.immibis.redlogic.RotatedTessellator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class GateDynamicRenderer extends TileEntitySpecialRenderer {

	RotatedTessellator rt = new RotatedTessellator();
	
	@Override
	public void renderTileEntityAt(TileEntity var1, double x, double y, double z, float partialTick) {
		GateTile te = (GateTile)var1;
		if(te.getType() == null)
			return;
		
		GateRendering gr = te.getType().getRendering();
		
		//System.out.println(te.getType()+", "+gr.pointerX.length+" pointers");
		
		if(gr.pointerX.length == 0)
			return;
		
		Minecraft.getMinecraft().renderEngine.bindTexture("/terrain.png");
		
		rt.base = Tessellator.instance;
		rt.x = x;
		rt.y = y;
		rt.z = z;
		rt.front = te.getFront();
		rt.side = te.getSide();
		rt.flipped = te.isFlipped();
		
		rt.base.startDrawingQuads();
		for(int k = 0; k < gr.pointerX.length; k++) {
			renderPointer(gr.pointerX[k]/16.0f, gr.pointerY[k]/16.0f, -(te.pointerPos + te.pointerSpeed * partialTick) * Math.PI / 180, 1/16f);
		}
		rt.base.draw();
	}
	
	private void renderPointer(float x, float z, double angle, float pixel) {
		// x' = x * cos(angle) + z * sin(angle)
		// z' = z * cos(angle) - x * sin(angle)
		
		float sin = (float)Math.sin(angle);
		float cos = (float)Math.cos(angle);
		
		float u = 8/256f;
		float v = 8/256f;
		
		float x1 = x - (3*pixel) * cos;
		float z1 = z + (3*pixel) * sin;
		
		float x2 = x - (6*pixel) * sin;
		float z2 = z - (6*pixel) * cos;
		
		float x3 = x + (3*pixel) * cos;
		float z3 = z - (3*pixel) * sin;
		
		float x4 = x + (3*pixel) * sin;
		float z4 = z + (3*pixel) * cos;
		
		float y1 = 5/16f;
		float y2 = 7/16f;
		
		rt.addVertexWithUV(x1, y1, z1, 0, 0);
		rt.addVertexWithUV(x1, y2, z1, 0, 0);
		rt.addVertexWithUV(x2, y2, z2, 0, 0);
		rt.addVertexWithUV(x2, y1, z2, 0, 0);
		
		rt.addVertexWithUV(x3, y2, z3, 0, 0);
		rt.addVertexWithUV(x3, y1, z3, 0, 0);
		rt.addVertexWithUV(x2, y1, z2, 0, 0);
		rt.addVertexWithUV(x2, y2, z2, 0, 0);
		
		rt.addVertexWithUV(x3, y1, z3, 0, 0);
		rt.addVertexWithUV(x3, y2, z3, 0, 0);
		rt.addVertexWithUV(x4, y2, z4, 0, 0);
		rt.addVertexWithUV(x4, y1, z4, 0, 0);
		
		rt.addVertexWithUV(x1, y2, z1, 0, 0);
		rt.addVertexWithUV(x1, y1, z1, 0, 0);
		rt.addVertexWithUV(x4, y1, z4, 0, 0);
		rt.addVertexWithUV(x4, y2, z4, 0, 0);
		
		rt.addVertexWithUV(x1, y1, z1, u-3/256f, v);
		rt.addVertexWithUV(x2, y1, z2, u, v-6/256f);
		rt.addVertexWithUV(x3, y1, z3, u+3/256f, v);
		rt.addVertexWithUV(x4, y1, z4, u, v+3/256f);
		
		rt.addVertexWithUV(x4, y2, z4, u, v+3/256f);
		rt.addVertexWithUV(x3, y2, z3, u+3/256f, v);
		rt.addVertexWithUV(x2, y2, z2, u, v-6/256f);
		rt.addVertexWithUV(x1, y2, z1, u-3/256f, v);
		
	}

}
