package mods.immibis.redlogic;

import mods.immibis.redlogic.gates.GateTile;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import cpw.mods.fml.common.registry.LanguageRegistry;

public class ItemScrewdriver extends Item {
	public ItemScrewdriver(int id_minus_256) {
		super(id_minus_256);
		setUnlocalizedName("immibis/redlogic:screwdriver");
		LanguageRegistry.addName(this, "Screwdriver");
		setCreativeTab(CreativeTabs.tabTools);
		setMaxStackSize(1);
	}
	
	@Override
	public boolean onItemUse(ItemStack stack, EntityPlayer ply, World w, int x, int y, int z, int side, float par8, float par9, float par10) {
		if(w.getBlockId(x, y, z) == RedLogicMod.gates.blockID) {
		
			if(w.isRemote)
				return true;
			
			GateTile te = (GateTile)w.getBlockTileEntity(x, y, z);
			if(ply.isSneaking())
				te.configure();
			else
				te.rotate();
			
			return true;
		}
		
		return false;
	}
}
