package mffs;

import ic2.api.IWrenchable;
import net.minecraft.src.Container;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NetworkManager;
import net.minecraft.src.Packet;
import net.minecraft.src.Packet132TileEntityData;
import net.minecraft.src.TileEntity;

public abstract class TileEntityMaschines extends TileEntityMFFS implements IWrenchable {

	private boolean init;
	private boolean active;
	private short facing;
	private float wrenchRate;
	protected long activatedTime;

	public TileEntityMaschines()
	{
		init = true;
		active = false;
		facing = -1;
		wrenchRate = 1.0F;
	}

	public void readFromNBT(NBTTagCompound nbttagcompound) {

		super.readFromNBT(nbttagcompound);
		facing = nbttagcompound.getShort("facing");
		active = nbttagcompound.getBoolean("active");
		wrenchRate = nbttagcompound.getFloat("wrenchRate");
		activatedTime = nbttagcompound.getLong("activatedTime");
	}

	public void writeToNBT(NBTTagCompound nbttagcompound) {
		super.writeToNBT(nbttagcompound);
		nbttagcompound.setShort("facing", facing);
		nbttagcompound.setBoolean("active", active);
		nbttagcompound.setFloat("wrenchRate", wrenchRate);
		nbttagcompound.setLong("activatedTime", activatedTime);
	}

	public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
		return false;
	}
	
	// server-only override
	public Packet getDescriptionPacket() {
		Packet132TileEntityData p = new Packet132TileEntityData();
		p.xPosition = xCoord;
		p.yPosition = yCoord;
		p.zPosition = zCoord;
		p.customParam1 = (facing & 0xffff) | (active ? 0x10000 : 0);
		return p;
	}
	
	// client-only override
	public void onDataPacket(NetworkManager net, Packet132TileEntityData p) {
		facing = (short)p.customParam1;
		active = (p.customParam1 & 0x10000) != 0;
	}

	public void setFacing(short i) {
		facing = i;
		worldObj.markBlockNeedsUpdate(xCoord, yCoord, zCoord);
	}

	public boolean getActive() {
		return active;
	}

	public void setActive(boolean flag) {
		if(!active && flag)
			activatedTime = worldObj.getWorldTime();
		active = flag;
		worldObj.markBlockNeedsUpdate(xCoord, yCoord, zCoord);
	}

	public short getFacing() {
		return facing;
	}

	public void setWrenchRate(float flag) {
		wrenchRate = flag;
	}

	public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
		if (getWrenchDropRate() <= 0.0F) {
			return false;
		}
		return true;
	}

	public float getWrenchDropRate() {
		return wrenchRate;
	}

	public boolean isInit() {
		return init;
	}

	public void setInit(boolean init) {
		this.init = init;
	}

}
