package mffs;

import java.util.Iterator;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.TileEntity;
import net.minecraft.server.mod_ModularForceFieldSystem;

public class TileEntityTubeProjektor extends TileEntityProjektor
{
    private int length = 1;
    private int maxlength = 32;
    private int radius = 2;
    private int maxradius = 5;
    private short mode_designe = 1;
    private boolean inhiitor = true;

    public void handleButton(int var1)
    {
        if (!this.getActive())
        {
            switch (var1)
            {
                case 0:
                    if (!this.getActive() && this.getRadius() < this.getMaxradius())
                    {
                        this.setRadius(this.getRadius() + 1);
                    }

                    break;

                case 1:
                    if (!this.getActive() && this.getRadius() > 2)
                    {
                        this.setRadius(this.getRadius() - 1);
                    }

                    break;

                case 2:
                    if (!this.getActive() && this.getlength() < this.getMaxlength())
                    {
                        this.setlength(this.getlength() + 1);
                    }

                    break;

                case 3:
                    if (!this.getActive() && this.getlength() > 1)
                    {
                        this.setlength(this.getlength() - 1);
                    }

                    break;

                case 4:
                    if (!this.getActive() && this.getmode_designe() < 2)
                    {
                        this.setmode_designe((short)(this.getmode_designe() + 1));
                    }

                    break;

                case 5:
                    if (!this.getActive() && this.getmode_designe() > 1)
                    {
                        this.setmode_designe((short)(this.getmode_designe() - 1));
                    }
            }
        }
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.length = var1.getInt("length");
        this.radius = var1.getInt("radius");
        this.mode_designe = var1.getShort("mode_designe");
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setInt("length", this.length);
        var1.setInt("radius", this.radius);
        var1.setShort("mode_designe", this.mode_designe);
    }

    public int getMaxlength()
    {
        return this.maxlength;
    }

    public int getlength()
    {
        return this.length;
    }

    public int getRadius()
    {
        return this.radius;
    }

    public int getMaxradius()
    {
        return this.maxradius;
    }

    public void setRadius(int var1)
    {
        this.radius = var1;
        ++this.updateCount;
    }

    public void setRadiusinit(int var1)
    {
        this.radius = var1;
        ++this.updateCount;
    }

    public void setlength(int var1)
    {
        this.length = var1;
        ++this.updateCount;
    }

    public void setlengthinit(int var1)
    {
        this.length = var1;
        ++this.updateCount;
    }

    public short getmode_designe()
    {
        return this.mode_designe;
    }

    public void setmode_designe(short var1)
    {
        this.mode_designe = var1;
        ++this.updateCount;
    }

    public void setmode_designeinit(short var1)
    {
        this.mode_designe = var1;
        ++this.updateCount;
    }

    public void addtogrid()
    {
        if (!this.world.isStatic)
        {
            Linkgrid.getWorldMap(this.world).getProjektor().put(Integer.valueOf(this.getProjektor_ID()), this);
        }
    }

    public void removefromgrid()
    {
        if (!this.world.isStatic)
        {
            Linkgrid.getWorldMap(this.world).getProjektor().remove(Integer.valueOf(this.getProjektor_ID()));
        }
    }

    public boolean wrenchCanSetFacing(EntityHuman var1, int var2)
    {
        if (this.getFacing() != var2 && !this.getActive())
        {
            this.setFacing((short)var2);
            this.world.notify(this.x, this.y, this.z);
            return true;
        }
        else
        {
            return false;
        }
    }

    /**
     * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
     * ticks and creates a new spawn inside its implementation.
     */
    public void q_()
    {
        if (!this.world.isStatic)
        {
            if (this.getLinkGenerator_ID() != 0)
            {
                this.setLinkGenerator(true);

                try
                {
                    this.setLinkPower(((TileEntityGeneratorCore)Linkgrid.getWorldMap(this.world).getGenerator().get(Integer.valueOf(this.getLinkGenerator_ID()))).getForcepower());
                    this.setMaxlinkPower(((TileEntityGeneratorCore)Linkgrid.getWorldMap(this.world).getGenerator().get(Integer.valueOf(this.getLinkGenerator_ID()))).getMaxforcepower());
                }
                catch (NullPointerException var3)
                {
                    this.setLinkGenerator(false);
                    this.setLinkPower(0);
                    this.setMaxlinkPower(1000000);
                }
            }
            else
            {
                this.setLinkGenerator(false);
                this.setLinkPower(0);
                this.setMaxlinkPower(1000000);
            }

            if (this.isCreate() && this.getLinkGenerator_ID() != 0)
            {
                this.addtogrid();
                this.addfreqcard();
                this.setCreate(false);

                if (this.getActive())
                {
                    this.checkupdates();
                    this.fieldcalculation(true);
                }
            }

            boolean var1 = this.world.isBlockPowered(this.x, this.y, this.z);
            boolean var2 = this.world.isBlockIndirectlyPowered(this.x, this.y, this.z);

            if ((var1 || var2) && this.isLinkGenerator() && this.getLinkPower() > this.Forcepowerneed(this.radius * this.radius * 6, true) && !this.getActive())
            {
                this.setActive(true);
                this.fieldcalculation(false);
                this.FieldGenerate(true);
                this.world.notify(this.x, this.y, this.z);
            }

            if ((!var1 && !var2 || !this.isLinkGenerator() || this.getLinkPower() < this.Forcepowerneed(this.length * this.radius * 4, false)) && this.getActive())
            {
                this.setActive(false);
                this.destroyField();
                this.world.notify(this.x, this.y, this.z);
            }

            if (this.getActive() && this.getWrenchDropRate() != -1.0F)
            {
                this.setWrenchRate(-1.0F);
            }

            if (!this.getActive() && this.getWrenchDropRate() != 1.0F)
            {
                this.setWrenchRate(1.0F);
            }

            if (this.getActive())
            {
                this.FieldGenerate(false);
            }

            if (this.getTicker() == 10)
            {
                this.checkupdates();
                this.addfreqcard();
                this.setTicker((short)0);
            }

            this.setTicker((short)(this.getTicker() + 1));
        }
    }

    public void checkupdates()
    {
        this.setSubwater(false);
        this.setHardner(false);
        this.setCamouflage(false);

        for (int var1 = this.x - 1; var1 <= this.x + 1; ++var1)
        {
            for (int var2 = this.y - 1; var2 <= this.y + 1; ++var2)
            {
                for (int var3 = this.z - 1; var3 <= this.z + 1; ++var3)
                {
                    if (this.world.getTypeId(var1, var2, var3) == mod_ModularForceFieldSystem.MFFSUpgrades.id)
                    {
                        int var4 = this.world.getData(var1, var2, var3);
                        TileEntity var5 = this.world.getTileEntity(var1, var2, var3);

                        if (var5 != null)
                        {
                            if (((TileEntityPassivUpgrade)var5).getconectet_ID() == 0 && (var4 == 1 || var4 == 3 || var4 == 7))
                            {
                                ((TileEntityPassivUpgrade)var5).setconectet_ID(this.getProjektor_ID());
                                ((TileEntityPassivUpgrade)var5).setConnectet_typID((short)2);
                                this.world.k(var5.x, var5.y, var5.z);
                            }

                            if (var4 == 7 && ((TileEntityCamoflageUpgrade)var5).getItem_ID() != this.getTextur())
                            {
                                this.setTextur(((TileEntityCamoflageUpgrade)var5).getItem_ID());
                            }

                            if (((TileEntityPassivUpgrade)var5).getconectet_ID() == this.getProjektor_ID() && ((TileEntityPassivUpgrade)var5).getConnectet_typID() == 2)
                            {
                                if (((TileEntityPassivUpgrade)var5).getActive() != this.getActive())
                                {
                                    ((TileEntityPassivUpgrade)var5).setActive(this.getActive());
                                }

                                switch (var4)
                                {
                                    case 1:
                                        this.setSubwater(true);
                                        break;

                                    case 3:
                                        this.setHardner(true);
                                        break;

                                    case 7:
                                        this.setCamouflage(true);
                                }
                            }
                        }
                    }
                }
            }
        }

        if (this.isCamouflage())
        {
            this.setffmeta((short)2);
        }
        else
        {
            this.setffmeta((short)0);
        }
    }

    public void fieldcalculation(boolean var1)
    {
        if (!this.field_queue.isEmpty())
        {
            this.field_queue.clear();
        }

        boolean var2 = false;
        boolean var3 = false;
        boolean var4 = false;
        int var5 = 0;
        int var6 = 0;
        int var7 = 0;
        int var8 = 0;
        int var9 = 0;
        int var10 = 0;
        int var11 = 0;
        byte var12 = 0;
        int var13 = 0;

        if (this.getFacing() == 0 || this.getFacing() == 1)
        {
            var6 = this.length;
            var5 = this.radius;
            var7 = this.radius;

            if (this.mode_designe == 2 && this.getFacing() == 0)
            {
                var9 = this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 1)
            {
                var9 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 0)
            {
                var9 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 1)
            {
                var9 = this.length;
            }
        }

        if (this.getFacing() == 2 || this.getFacing() == 3)
        {
            var6 = this.radius;
            var7 = this.length;
            var5 = this.radius;

            if (this.mode_designe == 2 && this.getFacing() == 3)
            {
                var10 = this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 2)
            {
                var10 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 3)
            {
                var13 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 2)
            {
                var13 = this.length;
            }
        }

        if (this.getFacing() == 4 || this.getFacing() == 5)
        {
            var6 = this.radius;
            var7 = this.radius;
            var5 = this.length;

            if (this.mode_designe == 2 && this.getFacing() == 5)
            {
                var8 = this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 4)
            {
                var8 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 5)
            {
                var11 = this.length - this.length;
            }

            if (this.mode_designe == 2 && this.getFacing() == 4)
            {
                var11 = this.length;
            }
        }

        for (int var14 = 0 - var7 + var10; var14 <= var7 - var13; ++var14)
        {
            for (int var15 = 0 - var5 + var8; var15 <= var5 - var11; ++var15)
            {
                for (int var16 = 0 - var6 + var9; var16 <= var6 - var12; ++var16)
                {
                    this.hasher.setLength(0);
                    this.hasher.append(this.x + var15).append("/").append(this.y + var16).append("/").append(this.z + var14);
                    ForceFieldWorldMap var17 = WorldMap.getForceFieldforWorld(this.world).addandgetffmp(this.x + var15, this.y + var16, this.z + var14);
                    int var18 = var5;
                    int var19 = var6;
                    int var20 = var7;

                    if (var5 == this.length && (this.getFacing() == 4 || this.getFacing() == 5))
                    {
                        var18 = var5 + 1;
                    }

                    if (var6 == this.length && (this.getFacing() == 0 || this.getFacing() == 1))
                    {
                        var19 = var6 + 1;
                    }

                    if (var7 == this.length && (this.getFacing() == 2 || this.getFacing() == 3))
                    {
                        var20 = var7 + 1;
                    }

                    if (var15 != 0 - var18 && var15 != var18 && var16 != 0 - var19 && var16 != var19 && var14 != 0 - var20 && var14 != var20)
                    {
                        if (this.isSubwater() && this.world.getMaterial(this.x + var15, this.y + var16, this.z + var14).isLiquid())
                        {
                            this.world.setTypeId(this.x + var15, this.y + var16, this.z + var14, 0);
                        }

                        if (var17.listsize() > 0 && var17.ffworld_getfistactive() && var17.ffworld_getfirstfreespace() && var17.ffworld_getfirstGenerator_ID() == this.getLinkGenerator_ID())
                        {
                            var17.ffworld_setfistactive(false);
                            var17.ffworld_setfirstfreeospace(true);
                            this.world.setTypeId(this.x + var15, this.y + var16, this.z + var14, 0);
                        }
                    }
                    else
                    {
                        boolean var21 = !this.world.getMaterial(this.x + var15, this.y + var16, this.z + var14).isBuildable();
                        boolean var22 = this.world.getTypeId(this.x + var15, this.y + var16, this.z + var14) == mod_ModularForceFieldSystem.MFFSFieldblock.id;

                        if (var22)
                        {
                            var21 = true;
                        }

                        if (var17.listsize() == 0)
                        {
                            if (this.getffmeta() == 2)
                            {
                                TexturworldMap.getTexturMap(Integer.valueOf(this.world.worldProvider.dimension)).add(this.x + var15, this.y + var16, this.z + var14, this.getTextur());
                            }

                            var17.ffworld_addFirst(new ForceFieldBlock(this.getLinkGenerator_ID(), this.getProjektor_ID(), var21, true, this.getffmeta()));
                            this.field_queue.add(this.hasher.toString());
                        }
                        else
                        {
                            var17.ffworld_addLast(new ForceFieldBlock(this.getLinkGenerator_ID(), this.getProjektor_ID(), var21, false, this.getffmeta()));
                            this.field_queue.add(this.hasher.toString());
                        }
                    }
                }
            }
        }
    }

    public void destroyField()
    {
        Iterator var1 = this.field_queue.iterator();

        while (var1.hasNext())
        {
            String var2 = (String)var1.next();
            ForceFieldWorldMap var3 = WorldMap.getForceFieldforWorld(this.world).getFFWM(var2.toString());

            if (var3.listsize() >= 1)
            {
                if (var3.ffworld_getfirstfreespace() && var3.ffworld_getfistactive() && var3.ffworld_getfirstProjektor_ID() == this.getProjektor_ID())
                {
                    var3.ffworld_remove(this.getProjektor_ID());
                    this.world.setTypeId(var3.getX(), var3.getY(), var3.getZ(), 0);

                    if (var3.listsize() >= 1)
                    {
                        var3.ffworld_setfistactive(true);
                        var3.ffworld_setfirstfreeospace(false);
                    }
                }
                else
                {
                    var3.ffworld_remove(this.getProjektor_ID());
                }
            }
        }

        this.field_queue.clear();
    }

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }

    public int[] getUpdate()
    {
        return new int[] {this.length, this.maxlength, this.radius, this.maxradius, this.mode_designe, this.inhiitor ? 1 : 0};
    }

    public void handleUpdate(int[] var1)
    {
        this.length = var1[0];
        this.maxlength = var1[1];
        this.radius = var1[2];
        this.maxradius = var1[3];
        this.mode_designe = (short)var1[4];
        this.inhiitor = var1[5] != 0;
    }
}
