package mffs;

import ic2.common.TileEntityNuclearReactor;
import ic2.common.TileEntityReactorChamber;
import java.util.Iterator;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.TileEntity;
import net.minecraft.server.mod_ModularForceFieldSystem;

public class TileEntityReaktorField extends TileEntityProjektor
{
    private boolean watercool = false;
    private boolean isreaktor = false;
    private int reactorx = 0;
    private int reactory = 0;
    private int reactorz = 0;
    private int reactordist = 0;
    private int reactorsize = 0;
    private int reactorheat = 0;
    private int maxheat;

    public int[] getUpdate()
    {
        return new int[] {this.watercool ? 1 : 0, this.isreaktor ? 1 : 0, this.reactorx, this.reactory, this.reactorz, this.reactordist, this.reactorsize, this.reactorheat, this.maxheat};
    }

    public void handleUpdate(int[] var1)
    {
        this.watercool = var1[0] != 0;
        this.isreaktor = var1[1] != 0;
        this.reactorx = var1[2];
        this.reactory = var1[3];
        this.reactorz = var1[4];
        this.reactordist = var1[5];
        this.reactorsize = var1[6];
        this.reactorheat = var1[7];
        this.maxheat = var1[8];
    }

    public void handleButton(int var1)
    {
        if (!this.getActive() && var1 == 0)
        {
            this.setWatercool(!this.isWatercool());
        }
    }

    public TileEntityReaktorField()
    {
        this.setDropper(false);
        this.setHardner(false);
    }

    public int getReactorx()
    {
        return this.reactorx;
    }

    public int getReactory()
    {
        return this.reactory;
    }

    public int getReactorz()
    {
        return this.reactorz;
    }

    public int getReactordist()
    {
        return this.reactordist;
    }

    public int getReactorsize()
    {
        return this.reactorsize;
    }

    public int getReactorheat()
    {
        return this.reactorheat;
    }

    public boolean isWatercool()
    {
        return this.watercool;
    }

    public void setWatercoolinit(boolean var1)
    {
        this.watercool = var1;
        ++this.updateCount;
    }

    public void setWatercool(boolean var1)
    {
        this.watercool = var1;
        ++this.updateCount;
    }

    public int getReaktorheat()
    {
        return this.reactorheat;
    }

    public void setReaktorheat(int var1)
    {
        this.reactorheat = var1;
        ++this.updateCount;
    }

    public boolean isIsreaktor()
    {
        return this.isreaktor;
    }

    public void setIsreaktor(boolean var1)
    {
        this.isreaktor = var1;
        ++this.updateCount;
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.watercool = var1.getBoolean("watercool");
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setBoolean("watercool", this.watercool);
    }

    public void addtogrid()
    {
        if (!this.world.isStatic)
        {
            Linkgrid.getWorldMap(this.world).getProjektor().put(Integer.valueOf(this.getProjektor_ID()), this);
        }
    }

    public void removefromgrid()
    {
        if (!this.world.isStatic)
        {
            Linkgrid.getWorldMap(this.world).getProjektor().remove(Integer.valueOf(this.getProjektor_ID()));
        }
    }

    private boolean scanforNuclearReaktor()
    {
        for (int var1 = this.x - 2; var1 <= this.x + 2; ++var1)
        {
            for (int var2 = this.y - 2; var2 <= this.y + 2; ++var2)
            {
                for (int var3 = this.z - 2; var3 <= this.z + 2; ++var3)
                {
                    TileEntity var4 = this.world.getTileEntity(var1, var2, var3);

                    if (var4 instanceof TileEntityNuclearReactor)
                    {
                        this.reactorx = var1;
                        this.reactory = var2;
                        this.reactorz = var3;

                        if (Math.abs(this.x - this.reactorx) <= 1 && Math.abs(this.y - this.reactory) <= 1 && Math.abs(this.z - this.reactorz) <= 1)
                        {
                            this.reactordist = 1;
                        }
                        else
                        {
                            this.reactordist = 2;
                        }

                        return true;
                    }
                }
            }
        }

        return false;
    }

    private int scanforReaktorCamber()
    {
        int var1 = 0;

        if (this.world.getTileEntity(this.reactorx + 1, this.reactory, this.reactorz) instanceof TileEntityReactorChamber)
        {
            ++var1;
        }

        if (this.world.getTileEntity(this.reactorx - 1, this.reactory, this.reactorz) instanceof TileEntityReactorChamber)
        {
            ++var1;
        }

        if (this.world.getTileEntity(this.reactorx, this.reactory + 1, this.reactorz) instanceof TileEntityReactorChamber)
        {
            ++var1;
        }

        if (this.world.getTileEntity(this.reactorx, this.reactory - 1, this.reactorz) instanceof TileEntityReactorChamber)
        {
            ++var1;
        }

        if (this.world.getTileEntity(this.reactorx, this.reactory, this.reactorz + 1) instanceof TileEntityReactorChamber)
        {
            ++var1;
        }

        if (this.world.getTileEntity(this.reactorx, this.reactory, this.reactorz - 1) instanceof TileEntityReactorChamber)
        {
            ++var1;
        }

        return var1;
    }

    /**
     * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
     * ticks and creates a new spawn inside its implementation.
     */
    public void q_()
    {
        if (!this.world.isStatic)
        {
            if (!this.isIsreaktor())
            {
                this.setIsreaktor(this.scanforNuclearReaktor());
            }

            if (this.getLinkGenerator_ID() != 0)
            {
                this.setLinkGenerator(true);

                try
                {
                    this.setLinkPower(((TileEntityGeneratorCore)Linkgrid.getWorldMap(this.world).getGenerator().get(Integer.valueOf(this.getLinkGenerator_ID()))).getForcepower());
                    this.setMaxlinkPower(((TileEntityGeneratorCore)Linkgrid.getWorldMap(this.world).getGenerator().get(Integer.valueOf(this.getLinkGenerator_ID()))).getMaxforcepower());
                }
                catch (NullPointerException var4)
                {
                    this.setLinkGenerator(false);
                    this.setLinkPower(0);
                    this.setMaxlinkPower(1000000);
                    this.destroyField();
                }
            }
            else
            {
                this.setLinkGenerator(false);
                this.setLinkPower(0);
                this.setMaxlinkPower(1000000);
            }

            if (this.isCreate() && this.getLinkGenerator_ID() != 0)
            {
                this.addtogrid();
                this.addfreqcard();
                this.setCreate(false);

                if (this.getActive())
                {
                    this.checkupdates();
                    this.fieldcalculation(true);
                }
            }

            boolean var1 = this.world.isBlockPowered(this.x, this.y, this.z);
            boolean var2 = this.world.isBlockIndirectlyPowered(this.x, this.y, this.z);

            if (var1 || var2)
            {
                var2 = true;
            }

            switch (this.reactorsize)
            {
                case 0:
                    this.maxheat = 7500;
                    break;

                case 1:
                    this.maxheat = 8350;
                    break;

                case 2:
                    this.maxheat = 9200;
                    break;

                case 3:
                    this.maxheat = 10050;
                    break;

                case 4:
                    this.maxheat = 10900;
                    break;

                case 5:
                    this.maxheat = 11750;
                    break;

                case 6:
                    this.maxheat = 12600;
            }

            if (this.maxheat < this.reactorheat)
            {
                this.setHardner(true);
                var2 = true;
            }

            if ((this.reactorsize == 0 && this.reactordist == 1 || this.reactorsize >= 1 && this.reactordist == 2) && var2 && this.isLinkGenerator() && this.getLinkPower() > this.Forcepowerneed(150, true) && this.isIsreaktor() && !this.getActive())
            {
                this.setActive(true);
                this.checkupdates();
                this.fieldcalculation(false);
                this.FieldGenerate(true);
                this.world.notify(this.x, this.y, this.z);
            }

            if ((!var2 || !this.isLinkGenerator() || this.getLinkPower() < this.Forcepowerneed(150, false) || !this.isIsreaktor()) && this.getActive())
            {
                this.setActive(false);
                this.destroyField();
                this.setHardner(false);
                this.world.notify(this.x, this.y, this.z);
            }

            if (this.getActive() && this.getWrenchDropRate() != -1.0F)
            {
                this.setWrenchRate(-1.0F);
            }

            if (!this.getActive() && this.getWrenchDropRate() != 1.0F)
            {
                this.setWrenchRate(1.0F);
            }

            if (this.getActive())
            {
                this.FieldGenerate(false);
            }

            if (this.getTicker() == 10)
            {
                if (this.isreaktor)
                {
                    this.reactorsize = this.scanforReaktorCamber();
                    this.checkupdates();
                    TileEntity var3 = this.world.getTileEntity(this.reactorx, this.reactory, this.reactorz);

                    if (var3 instanceof TileEntityNuclearReactor)
                    {
                        this.setReaktorheat(((TileEntityNuclearReactor)var3).heat);

                        if (this.getActive())
                        {
                            this.refreshwater();
                        }
                    }
                    else
                    {
                        this.setIsreaktor(false);
                    }
                }
                else
                {
                    this.checkupdates();
                }

                this.addfreqcard();
                this.setTicker((short)0);
            }

            this.setTicker((short)(this.getTicker() + 1));
        }
    }

    public void refreshwater()
    {
        for (int var1 = 0 - this.reactordist; var1 <= this.reactordist; ++var1)
        {
            for (int var2 = 0 - this.reactordist; var2 <= this.reactordist; ++var2)
            {
                for (int var3 = 0 - this.reactordist; var3 <= this.reactordist; ++var3)
                {
                    if (this.watercool && this.world.getTypeId(this.reactorx + var2, this.reactory + var1, this.reactorz + var3) == 0)
                    {
                        this.world.setTypeId(this.reactorx + var2, this.reactory + var1, this.reactorz + var3, 8);
                        TileEntity var4 = (TileEntity)Linkgrid.getWorldMap(this.world).getGenerator().get(Integer.valueOf(this.getLinkGenerator_ID()));

                        if (var4 instanceof TileEntityGeneratorCore)
                        {
                            ((TileEntityGeneratorCore)var4).Energylost(1000);
                        }
                    }
                }
            }
        }
    }

    public void fieldcalculation(boolean var1)
    {
        if (!this.field_queue.isEmpty())
        {
            this.field_queue.clear();
        }

        for (int var2 = 0 - this.reactordist; var2 <= this.reactordist; ++var2)
        {
            for (int var3 = 0 - this.reactordist; var3 <= this.reactordist; ++var3)
            {
                for (int var4 = 0 - this.reactordist; var4 <= this.reactordist; ++var4)
                {
                    this.hasher.setLength(0);
                    this.hasher.append(this.reactorx + var3).append("/").append(this.reactory + var2).append("/").append(this.reactorz + var4);
                    ForceFieldWorldMap var5 = WorldMap.getForceFieldforWorld(this.world).addandgetffmp(this.reactorx + var3, this.reactory + var2, this.reactorz + var4);

                    if (var1)
                    {
                        var5.ffworld_remove(this.getProjektor_ID());
                    }

                    if (var3 != 0 - this.reactordist && var3 != this.reactordist && var2 != 0 - this.reactordist && var2 != this.reactordist && var4 != 0 - this.reactordist && var4 != this.reactordist)
                    {
                        if (this.watercool)
                        {
                            this.refreshwater();
                        }
                    }
                    else
                    {
                        boolean var6 = !this.world.getMaterial(this.reactorx + var3, this.reactory + var2, this.reactorz + var4).isBuildable();
                        boolean var7 = this.world.getTypeId(this.reactorx + var3, this.reactory + var2, this.reactorz + var4) == mod_ModularForceFieldSystem.MFFSFieldblock.id;

                        if (var7)
                        {
                            var6 = true;
                        }

                        if (var5.listsize() == 0)
                        {
                            var5.ffworld_addFirst(new ForceFieldBlock(this.getLinkGenerator_ID(), this.getProjektor_ID(), var6, true, (short)3));
                            this.field_queue.add(this.hasher.toString());
                        }
                        else
                        {
                            var5.ffworld_addLast(new ForceFieldBlock(this.getLinkGenerator_ID(), this.getProjektor_ID(), var6, false, (short)3));
                            this.field_queue.add(this.hasher.toString());
                        }
                    }
                }
            }
        }
    }

    public void destroyField()
    {
        Iterator var1 = this.field_queue.iterator();

        while (var1.hasNext())
        {
            String var2 = (String)var1.next();
            ForceFieldWorldMap var3 = WorldMap.getForceFieldforWorld(this.world).getFFWM(var2.toString());

            if (var3.listsize() >= 1)
            {
                if (var3.ffworld_getfirstfreespace() && var3.ffworld_getfistactive() && var3.ffworld_getfirstProjektor_ID() == this.getProjektor_ID())
                {
                    var3.ffworld_remove(this.getProjektor_ID());
                    this.world.setTypeId(var3.getX(), var3.getY(), var3.getZ(), 0);

                    if (var3.listsize() >= 1)
                    {
                        var3.ffworld_setfirstfreeospace(false);
                        var3.ffworld_setfistactive(true);
                    }
                }
                else
                {
                    var3.ffworld_remove(this.getProjektor_ID());
                }
            }
        }

        if (this.watercool)
        {
            for (int var4 = 0 - this.reactordist; var4 <= this.reactordist; ++var4)
            {
                for (int var5 = 0 - this.reactordist; var5 <= this.reactordist; ++var5)
                {
                    for (int var6 = 0 - this.reactordist; var6 <= this.reactordist; ++var6)
                    {
                        if (this.world.getTypeId(this.reactorx + var5, this.reactory + var4, this.reactorz + var6) == 8)
                        {
                            this.world.setTypeId(this.reactorx + var5, this.reactory + var4, this.reactorz + var6, 0);
                        }
                    }
                }
            }
        }

        this.field_queue.clear();
    }

    public void checkupdates()
    {
        for (int var1 = -2; var1 <= 2; ++var1)
        {
            for (int var2 = -2; var2 <= 2; ++var2)
            {
                for (int var3 = -2; var3 <= 2; ++var3)
                {
                    if ((var1 == 0 && var2 == 0 && (var3 == -2 || var3 == -1 || var3 == 1 || var3 == 2) || var1 == 0 && var3 == 0 && (var2 == -2 || var2 == -1 || var2 == 1 || var2 == 2) || var3 == 0 && var2 == 0 && (var1 == -2 || var1 == -1 || var1 == 1 || var1 == 2)) && this.world.getTypeId(this.reactorx + var1, this.reactory + var2, this.reactorz + var3) == mod_ModularForceFieldSystem.MFFSUpgrades.id)
                    {
                        int var4 = this.world.getData(this.reactorx + var1, this.reactory + var2, this.reactorz + var3);
                        TileEntity var5 = this.world.getTileEntity(this.reactorx + var1, this.reactory + var2, this.reactorz + var3);

                        if (var5 != null)
                        {
                            if (((TileEntityPassivUpgrade)var5).getconectet_ID() == 0 && var4 == 8)
                            {
                                ((TileEntityPassivUpgrade)var5).setconectet_ID(this.getProjektor_ID());
                                ((TileEntityPassivUpgrade)var5).setConnectet_typID((short)2);
                                this.world.k(var5.x, var5.y, var5.z);
                            }

                            if (((TileEntityPassivUpgrade)var5).getconectet_ID() == this.getProjektor_ID() && ((TileEntityPassivUpgrade)var5).getConnectet_typID() == 2 && ((TileEntityPassivUpgrade)var5).getActive() != this.getActive())
                            {
                                ((TileEntityPassivUpgrade)var5).setActive(this.getActive());
                            }
                        }
                    }

                    TileEntity var6;

                    if (this.world.getTypeId(this.reactorx + var1, this.reactory + var2, this.reactorz + var3) == mod_ModularForceFieldSystem.MFFSMaschines.id && this.world.getData(this.reactorx + var1, this.reactory + var2, this.reactorz + var3) == 8)
                    {
                        var6 = this.world.getTileEntity(this.reactorx + var1, this.reactory + var2, this.reactorz + var3);

                        if (var6 != null)
                        {
                            if (((TileEntityPassivUpgrade)var6).getconectet_ID() == 0)
                            {
                                ((TileEntityPassivUpgrade)var6).setconectet_ID(this.getProjektor_ID());
                                ((TileEntityPassivUpgrade)var6).setConnectet_typID((short)2);
                                this.world.k(var6.x, var6.y, var6.z);
                            }

                            if (((TileEntityPassivUpgrade)var6).getconectet_ID() == this.getProjektor_ID() && ((TileEntityPassivUpgrade)var6).getConnectet_typID() == 2)
                            {
                                if (((TileEntityPassivUpgrade)var6).getActive() != this.getActive())
                                {
                                    ((TileEntityPassivUpgrade)var6).setActive(this.getActive());
                                    this.world.k(var6.x, var6.y, var6.z);
                                }

                                if (((TileEntityReaktorCooler)var6).isIsreaktor() != this.isIsreaktor())
                                {
                                    ((TileEntityReaktorCooler)var6).setIsreaktor(this.isIsreaktor());
                                }

                                if (((TileEntityReaktorCooler)var6).getMaxheat() != this.maxheat)
                                {
                                    ((TileEntityReaktorCooler)var6).setMaxheat(this.maxheat);
                                }

                                if (((TileEntityReaktorCooler)var6).getReaktorx() != this.reactorx)
                                {
                                    ((TileEntityReaktorCooler)var6).setReaktorx(this.reactorx);
                                }

                                if (((TileEntityReaktorCooler)var6).getReaktory() != this.reactory)
                                {
                                    ((TileEntityReaktorCooler)var6).setReaktory(this.reactory);
                                }

                                if (((TileEntityReaktorCooler)var6).getReaktorz() != this.reactorz)
                                {
                                    ((TileEntityReaktorCooler)var6).setReaktorz(this.reactorz);
                                }
                            }
                        }
                    }

                    if (this.world.getTypeId(this.reactorx + var1, this.reactory + var2, this.reactorz + var3) == mod_ModularForceFieldSystem.MFFSMaschines.id && this.world.getData(this.reactorx + var1, this.reactory + var2, this.reactorz + var3) == 9)
                    {
                        var6 = this.world.getTileEntity(this.reactorx + var1, this.reactory + var2, this.reactorz + var3);

                        if (var6 != null)
                        {
                            if (((TileEntityPassivUpgrade)var6).getconectet_ID() == 0)
                            {
                                ((TileEntityPassivUpgrade)var6).setconectet_ID(this.getProjektor_ID());
                                ((TileEntityPassivUpgrade)var6).setConnectet_typID((short)2);
                                this.world.k(var6.x, var6.y, var6.z);
                            }

                            if (((TileEntityPassivUpgrade)var6).getconectet_ID() == this.getProjektor_ID() && ((TileEntityPassivUpgrade)var6).getConnectet_typID() == 2)
                            {
                                if (((TileEntityPassivUpgrade)var6).getActive() != this.getActive())
                                {
                                    ((TileEntityPassivUpgrade)var6).setActive(this.getActive());
                                    this.world.k(var6.x, var6.y, var6.z);
                                }

                                if (((TileEntityReaktorMonitor)var6).isIsreaktor() != this.isIsreaktor())
                                {
                                    ((TileEntityReaktorMonitor)var6).setIsreaktor(this.isIsreaktor());
                                }

                                if (((TileEntityReaktorMonitor)var6).getReaktorx() != this.reactorx)
                                {
                                    ((TileEntityReaktorMonitor)var6).setReaktorx(this.reactorx);
                                }

                                if (((TileEntityReaktorMonitor)var6).getReaktory() != this.reactory)
                                {
                                    ((TileEntityReaktorMonitor)var6).setReaktory(this.reactory);
                                }

                                if (((TileEntityReaktorMonitor)var6).getReaktorz() != this.reactorz)
                                {
                                    ((TileEntityReaktorMonitor)var6).setReaktorz(this.reactorz);
                                }

                                if (((TileEntityReaktorMonitor)var6).getMaxheat() != this.maxheat)
                                {
                                    ((TileEntityReaktorMonitor)var6).setMaxheat(this.maxheat);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }
}
