package mffs;

import java.util.Iterator;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.TileEntity;
import net.minecraft.server.mod_ModularForceFieldSystem;

public class TileEntityDirectionalProjektor extends TileEntityProjektor
{
    private int length = 1;
    private int maxlength = 32;
    private int distance = 0;
    private int maxdistance = 10;

    public void handleButton(int var1)
    {
        if (!this.getActive())
        {
            switch (var1)
            {
                case 0:
                    if (!this.getActive() && this.getlength() < this.getMaxlength())
                    {
                        this.setlength(this.getlength() + 1);
                    }

                    break;

                case 1:
                    if (!this.getActive() && this.getlength() > 1)
                    {
                        this.setlength(this.getlength() - 1);
                    }

                    break;

                case 2:
                    if (!this.getActive() && this.getDistance() < this.getMaxdistance())
                    {
                        this.setDistance(this.getDistance() + 1);
                    }

                    break;

                case 3:
                    if (!this.getActive() && this.getDistance() > 0)
                    {
                        this.setDistance(this.getDistance() - 1);
                    }
            }
        }
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.length = var1.getInt("length");
        this.distance = var1.getInt("distance");
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setInt("length", this.length);
        var1.setInt("distance", this.distance);
    }

    public void Check_con_Extender()
    {
        for (int var1 = this.x - 1; var1 <= this.x + 1; ++var1)
        {
            for (int var2 = this.y - 1; var2 <= this.y + 1; ++var2)
            {
                for (int var3 = this.z - 1; var3 <= this.z + 1; ++var3)
                {
                    TileEntity var4 = this.world.getTileEntity(var1, var2, var3);

                    if (var4 != null && var4 instanceof TileEntityDirectionalExtender)
                    {
                        if (((TileEntityDirectionalExtender)var4).getRemProjektor_ID() == 0 && !((TileEntityDirectionalExtender)var4).isCon_to_projektor() && this.getLinkGenerator_ID() != 0 && this.getProjektor_ID() != 0)
                        {
                            ((TileEntityDirectionalExtender)var4).setRemGenerator_ID(this.getLinkGenerator_ID());
                            ((TileEntityDirectionalExtender)var4).setRemProjektor_ID(this.getProjektor_ID());
                            ((TileEntityDirectionalExtender)var4).setCon_to_projektor(true);
                        }

                        if (((TileEntityDirectionalExtender)var4).isCon_to_projektor())
                        {
                            if (((TileEntityDirectionalExtender)var4).getffmeta() != this.getffmeta())
                            {
                                ((TileEntityDirectionalExtender)var4).setffmeta(this.getffmeta());
                            }

                            if (((TileEntityDirectionalExtender)var4).getTextur() != this.getTextur())
                            {
                                ((TileEntityDirectionalExtender)var4).setTextur(this.getTextur());
                            }

                            if (((TileEntityDirectionalExtender)var4).getFacing() != this.getFacing())
                            {
                                ((TileEntityDirectionalExtender)var4).setFacing(this.getFacing());
                                this.world.notify(var1, var2, var3);
                            }

                            if (((TileEntityDirectionalExtender)var4).getDistance() != this.getDistance())
                            {
                                ((TileEntityDirectionalExtender)var4).setDistance(this.getDistance());
                            }

                            if (((TileEntityDirectionalExtender)var4).getLength() != this.getlength())
                            {
                                ((TileEntityDirectionalExtender)var4).setlength(this.getlength());
                            }

                            if (((TileEntityDirectionalExtender)var4).isHardner() != this.isHardner())
                            {
                                ((TileEntityDirectionalExtender)var4).setHardner(this.isHardner());
                            }

                            if (((TileEntityDirectionalExtender)var4).isPreactive() != this.getActive())
                            {
                                ((TileEntityDirectionalExtender)var4).setPreactive(this.getActive());
                            }
                        }
                    }
                }
            }
        }
    }

    public int getMaxlength()
    {
        return this.maxlength;
    }

    public int getlength()
    {
        return this.length;
    }

    public int getDistance()
    {
        return this.distance;
    }

    public int getMaxdistance()
    {
        return this.maxdistance;
    }

    public void setDistance(int var1)
    {
        this.distance = var1;
        ++this.updateCount;
    }

    public void setDistanceinit(int var1)
    {
        this.distance = var1;
        ++this.updateCount;
    }

    public void setlength(int var1)
    {
        this.length = var1;
        ++this.updateCount;
    }

    public void setlengthinit(int var1)
    {
        this.length = var1;
        ++this.updateCount;
    }

    public void addtogrid()
    {
        if (!this.world.isStatic)
        {
            Linkgrid.getWorldMap(this.world).getProjektor().put(Integer.valueOf(this.getProjektor_ID()), this);
        }
    }

    public void removefromgrid()
    {
        if (!this.world.isStatic)
        {
            Linkgrid.getWorldMap(this.world).getProjektor().remove(Integer.valueOf(this.getProjektor_ID()));
        }
    }

    public boolean wrenchCanSetFacing(EntityHuman var1, int var2)
    {
        if (this.getFacing() != var2 && !this.getActive())
        {
            this.setFacing((short)var2);
            this.world.notify(this.x, this.y, this.z);
            return true;
        }
        else
        {
            return false;
        }
    }

    /**
     * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
     * ticks and creates a new spawn inside its implementation.
     */
    public void q_()
    {
        if (!this.world.isStatic)
        {
            if (this.isCreate() && this.getLinkGenerator_ID() != 0)
            {
                this.addtogrid();
                this.setCreate(false);

                if (this.getActive())
                {
                    this.checkupdates();
                    this.Check_con_Extender();
                    this.fieldcalculation(true);
                }
            }

            if (this.getLinkGenerator_ID() != 0)
            {
                this.setLinkGenerator(true);

                try
                {
                    this.setLinkPower(((TileEntityGeneratorCore)Linkgrid.getWorldMap(this.world).getGenerator().get(Integer.valueOf(this.getLinkGenerator_ID()))).getForcepower());
                    this.setMaxlinkPower(((TileEntityGeneratorCore)Linkgrid.getWorldMap(this.world).getGenerator().get(Integer.valueOf(this.getLinkGenerator_ID()))).getMaxforcepower());
                }
                catch (NullPointerException var3)
                {
                    this.setLinkGenerator(false);
                    this.setLinkPower(0);
                    this.setMaxlinkPower(1000000);
                }
            }
            else
            {
                this.setLinkGenerator(false);
                this.setLinkPower(0);
                this.setMaxlinkPower(1000000);
            }

            boolean var1 = this.world.isBlockPowered(this.x, this.y, this.z);
            boolean var2 = this.world.isBlockIndirectlyPowered(this.x, this.y, this.z);

            if ((var1 || var2) && this.isLinkGenerator() && this.getLinkPower() > this.Forcepowerneed(this.length, true) && !this.getActive())
            {
                this.setActive(true);
                this.checkupdates();
                this.Check_con_Extender();
                this.fieldcalculation(false);
                this.FieldGenerate(true);
                this.world.notify(this.x, this.y, this.z);
            }

            if ((!var1 && !var2 || !this.isLinkGenerator() && this.getLinkPower() < this.Forcepowerneed(this.length, false)) && this.getActive())
            {
                this.setActive(false);
                this.Check_con_Extender();
                this.destroyField();
                this.world.notify(this.x, this.y, this.z);
            }

            if (this.getActive() && this.getWrenchDropRate() != -1.0F)
            {
                this.setWrenchRate(-1.0F);
            }

            if (!this.getActive() && this.getWrenchDropRate() != 1.0F)
            {
                this.setWrenchRate(1.0F);
            }

            if (this.getActive())
            {
                this.FieldGenerate(false);
            }

            if (this.getTicker() == 10)
            {
                this.addfreqcard();
                this.checkupdates();
                this.Check_con_Extender();
                this.setTicker((short)0);
            }

            this.setTicker((short)(this.getTicker() + 1));
        }
    }

    public void checkupdates()
    {
        this.setHardner(false);
        this.setZapper(false);
        this.setCamouflage(false);

        for (int var1 = this.x - 1; var1 <= this.x + 1; ++var1)
        {
            for (int var2 = this.y - 1; var2 <= this.y + 1; ++var2)
            {
                for (int var3 = this.z - 1; var3 <= this.z + 1; ++var3)
                {
                    if (this.world.getTypeId(var1, var2, var3) == mod_ModularForceFieldSystem.MFFSUpgrades.id)
                    {
                        int var4 = this.world.getData(var1, var2, var3);
                        TileEntity var5 = this.world.getTileEntity(var1, var2, var3);

                        if (var5 != null)
                        {
                            if (((TileEntityPassivUpgrade)var5).getconectet_ID() == 0 && (var4 == 3 || var4 == 6 || var4 == 7))
                            {
                                ((TileEntityPassivUpgrade)var5).setconectet_ID(this.getProjektor_ID());
                                ((TileEntityPassivUpgrade)var5).setConnectet_typID((short)2);
                                this.world.k(var5.x, var5.y, var5.z);
                            }

                            if (var4 == 7 && ((TileEntityCamoflageUpgrade)var5).getconectet_ID() == this.getProjektor_ID() && ((TileEntityCamoflageUpgrade)var5).getConnectet_typID() == 2)
                            {
                                if (((TileEntityCamoflageUpgrade)var5).getItem_ID() != this.getTextur())
                                {
                                    this.setTextur(((TileEntityCamoflageUpgrade)var5).getItem_ID());
                                }

                                if (((TileEntityCamoflageUpgrade)var5).getActive() != this.getActive())
                                {
                                    ((TileEntityCamoflageUpgrade)var5).setActive(this.getActive());
                                }

                                if (((TileEntityCamoflageUpgrade)var5).getWrenchDropRate() != this.getWrenchDropRate())
                                {
                                    ((TileEntityCamoflageUpgrade)var5).setWrenchRate(this.getWrenchDropRate());
                                }
                            }

                            if (((TileEntityPassivUpgrade)var5).getconectet_ID() == this.getProjektor_ID() && ((TileEntityPassivUpgrade)var5).getConnectet_typID() == 2)
                            {
                                if (((TileEntityPassivUpgrade)var5).getActive() != this.getActive())
                                {
                                    ((TileEntityPassivUpgrade)var5).setActive(this.getActive());
                                }

                                switch (var4)
                                {
                                    case 3:
                                        this.setHardner(true);

                                    case 4:
                                    case 5:
                                    default:
                                        break;

                                    case 6:
                                        this.setZapper(true);
                                        break;

                                    case 7:
                                        this.setCamouflage(true);
                                }
                            }
                        }
                    }
                }
            }
        }

        if (this.isZapper())
        {
            this.setffmeta((short)1);
        }
        else
        {
            this.setffmeta((short)0);
        }

        if (this.isCamouflage())
        {
            this.setffmeta((short)2);
        }
    }

    public void fieldcalculation(boolean var1)
    {
        if (!this.field_queue.isEmpty())
        {
            this.field_queue.clear();
        }

        int var2 = 0;
        int var3 = 0;
        int var4 = 0;

        for (int var5 = 1; var5 < this.getlength() + 1; ++var5)
        {
            if (this.getFacing() == 0)
            {
                var3 = var5 - var5 - var5 - this.distance;
            }

            if (this.getFacing() == 1)
            {
                var3 = var5 + this.distance;
            }

            if (this.getFacing() == 2)
            {
                var4 = var5 - var5 - var5 - this.distance;
            }

            if (this.getFacing() == 3)
            {
                var4 = var5 + this.distance;
            }

            if (this.getFacing() == 4)
            {
                var2 = var5 - var5 - var5 - this.distance;
            }

            if (this.getFacing() == 5)
            {
                var2 = var5 + this.distance;
            }

            this.hasher.setLength(0);
            this.hasher.append(this.x + var2).append("/").append(this.y + var3).append("/").append(this.z + var4);
            ForceFieldWorldMap var6 = WorldMap.getForceFieldforWorld(this.world).addandgetffmp(this.x + var2, this.y + var3, this.z + var4);
            boolean var7 = !this.world.getMaterial(this.x + var2, this.y + var3, this.z + var4).isBuildable();
            boolean var8 = this.world.getTypeId(this.x + var2, this.y + var3, this.z + var4) == mod_ModularForceFieldSystem.MFFSFieldblock.id;

            if (var8)
            {
                var7 = true;
            }

            if (var6.listsize() == 0)
            {
                if (this.getffmeta() == 2)
                {
                    TexturworldMap.getTexturMap(Integer.valueOf(this.world.worldProvider.dimension)).add(this.x + var2, this.y + var3, this.z + var4, this.getTextur());
                }

                var6.ffworld_addFirst(new ForceFieldBlock(this.getLinkGenerator_ID(), this.getProjektor_ID(), var7, true, this.getffmeta()));
                this.field_queue.add(this.hasher.toString());
            }
            else
            {
                var6.ffworld_addLast(new ForceFieldBlock(this.getLinkGenerator_ID(), this.getProjektor_ID(), var7, false, this.getffmeta()));
                this.field_queue.add(this.hasher.toString());
            }
        }
    }

    public void destroyField()
    {
        Iterator var1 = this.field_queue.iterator();

        while (var1.hasNext())
        {
            String var2 = (String)var1.next();
            ForceFieldWorldMap var3 = WorldMap.getForceFieldforWorld(this.world).getFFWM(var2.toString());

            if (var3.listsize() >= 1)
            {
                if (var3.ffworld_getfirstfreespace() && var3.ffworld_getfistactive() && var3.ffworld_getfirstProjektor_ID() == this.getProjektor_ID())
                {
                    var3.ffworld_remove(this.getProjektor_ID());
                    this.world.setTypeId(var3.getX(), var3.getY(), var3.getZ(), 0);

                    if (var3.listsize() >= 1)
                    {
                        var3.ffworld_setfistactive(true);
                    }
                }
                else
                {
                    var3.ffworld_remove(this.getProjektor_ID());
                }
            }
        }

        this.field_queue.clear();
    }

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }

    public int[] getUpdate()
    {
        return new int[] {this.length, this.maxlength, this.distance, this.maxdistance};
    }

    public void handleUpdate(int[] var1)
    {
        this.length = var1[0];
        this.maxlength = var1[1];
        this.distance = var1[2];
        this.maxdistance = var1[3];
    }
}
