package mffs;

import java.util.Iterator;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.TileEntity;
import net.minecraft.server.mod_ModularForceFieldSystem;

public class TileEntityDeflectorProjektor extends TileEntityProjektor
{
    private int lengthx = 0;
    private int lengthz = 0;
    private int maxlengthx = 32;
    private int maxlengthz = 32;
    private int distance = 0;
    private int maxdistance = 10;

    public int[] getUpdate()
    {
        return new int[] {this.lengthx, this.lengthz, this.maxlengthx, this.maxlengthz, this.distance, this.maxdistance};
    }

    public void handleUpdate(int[] var1)
    {
        this.lengthx = var1[0];
        this.lengthz = var1[1];
        this.maxlengthx = var1[2];
        this.maxlengthz = var1[3];
        this.distance = var1[4];
        this.maxdistance = var1[5];
    }

    public void handleButton(int var1)
    {
        if (!this.getActive())
        {
            switch (var1)
            {
                case 0:
                    if (this.getlengthx() < this.getMaxlengthx())
                    {
                        this.setlengthx(this.getlengthx() + 1);
                    }

                    break;

                case 1:
                    if (this.getlengthx() > 0)
                    {
                        this.setlengthx(this.getlengthx() - 1);
                    }

                    break;

                case 2:
                    if (this.getlengthz() < this.getMaxlengthz())
                    {
                        this.setlengthz(this.getlengthz() + 1);
                    }

                    break;

                case 3:
                    if (this.getlengthz() > 0)
                    {
                        this.setlengthz(this.getlengthz() - 1);
                    }

                    break;

                case 4:
                    if (this.getDistance() < this.getMaxdistance())
                    {
                        this.setDistance(this.getDistance() + 1);
                    }

                    break;

                case 5:
                    if (this.getDistance() > 0)
                    {
                        this.setDistance(this.getDistance() - 1);
                    }
            }
        }
    }

    /**
     * Reads a tile entity from NBT.
     */
    public void a(NBTTagCompound var1)
    {
        super.a(var1);
        this.lengthx = var1.getInt("lengthx");
        this.lengthz = var1.getInt("lengthz");
        this.distance = var1.getInt("distance");
    }

    /**
     * Writes a tile entity to NBT.
     */
    public void b(NBTTagCompound var1)
    {
        super.b(var1);
        var1.setInt("lengthx", this.lengthx);
        var1.setInt("lengthz", this.lengthz);
        var1.setInt("distance", this.distance);
    }

    public int getMaxlengthx()
    {
        return this.maxlengthx;
    }

    public int getlengthx()
    {
        return this.lengthx;
    }

    public int getMaxlengthz()
    {
        return this.maxlengthz;
    }

    public int getlengthz()
    {
        return this.lengthz;
    }

    public int getDistance()
    {
        return this.distance;
    }

    public int getMaxdistance()
    {
        return this.maxdistance;
    }

    public void setDistance(int var1)
    {
        this.distance = var1;
        ++this.updateCount;
    }

    public void setDistanceinit(int var1)
    {
        this.distance = var1;
        ++this.updateCount;
    }

    public void setlengthx(int var1)
    {
        this.lengthx = var1;
        ++this.updateCount;
    }

    public void setlengthxinit(int var1)
    {
        this.lengthx = var1;
        ++this.updateCount;
    }

    public void setlengthz(int var1)
    {
        this.lengthz = var1;
        ++this.updateCount;
    }

    public void setlengthzinit(int var1)
    {
        this.lengthz = var1;
        ++this.updateCount;
    }

    public void addtogrid()
    {
        if (!this.world.isStatic)
        {
            Linkgrid.getWorldMap(this.world).getProjektor().put(Integer.valueOf(this.getProjektor_ID()), this);
        }
    }

    public void removefromgrid()
    {
        if (!this.world.isStatic)
        {
            Linkgrid.getWorldMap(this.world).getProjektor().remove(Integer.valueOf(this.getProjektor_ID()));
        }
    }

    public boolean wrenchCanSetFacing(EntityHuman var1, int var2)
    {
        if (this.getFacing() != var2 && !this.getActive())
        {
            this.setFacing((short)var2);
            this.world.notify(this.x, this.y, this.z);
            return true;
        }
        else
        {
            return false;
        }
    }

    /**
     * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
     * ticks and creates a new spawn inside its implementation.
     */
    public void q_()
    {
        if (!this.world.isStatic)
        {
            if (this.isCreate() && this.getLinkGenerator_ID() != 0)
            {
                this.addtogrid();
                this.addfreqcard();
                this.setCreate(false);

                if (this.getActive())
                {
                    this.checkupdates();
                    this.fieldcalculation(true);
                }
            }

            if (this.getLinkGenerator_ID() != 0)
            {
                this.setLinkGenerator(true);

                try
                {
                    this.setLinkPower(((TileEntityGeneratorCore)Linkgrid.getWorldMap(this.world).getGenerator().get(Integer.valueOf(this.getLinkGenerator_ID()))).getForcepower());
                    this.setMaxlinkPower(((TileEntityGeneratorCore)Linkgrid.getWorldMap(this.world).getGenerator().get(Integer.valueOf(this.getLinkGenerator_ID()))).getMaxforcepower());
                }
                catch (NullPointerException var3)
                {
                    this.setLinkGenerator(false);
                    this.setLinkPower(0);
                    this.setMaxlinkPower(1000000);
                }
            }
            else
            {
                this.setLinkGenerator(false);
                this.setLinkPower(0);
                this.setMaxlinkPower(1000000);
            }

            boolean var1 = this.world.isBlockPowered(this.x, this.y, this.z);
            boolean var2 = this.world.isBlockIndirectlyPowered(this.x, this.y, this.z);

            if ((var1 || var2) && this.isLinkGenerator() && this.getLinkPower() > this.Forcepowerneed(this.lengthx * this.lengthz, true) && !this.getActive())
            {
                this.setActive(true);
                this.fieldcalculation(false);
                this.FieldGenerate(true);
                this.world.notify(this.x, this.y, this.z);
            }

            if ((!var1 && !var2 || !this.isLinkGenerator() || this.getLinkPower() < this.Forcepowerneed(this.lengthx * this.lengthz, false)) && this.getActive())
            {
                this.setActive(false);
                this.destroyField();
                this.world.notify(this.x, this.y, this.z);
            }

            if (this.getActive() && this.getWrenchDropRate() != -1.0F)
            {
                this.setWrenchRate(-1.0F);
            }

            if (!this.getActive() && this.getWrenchDropRate() != 1.0F)
            {
                this.setWrenchRate(1.0F);
            }

            if (this.getActive())
            {
                this.FieldGenerate(false);
            }

            if (this.getTicker() == 10)
            {
                this.checkupdates();
                this.addfreqcard();
                this.setTicker((short)0);
            }

            this.setTicker((short)(this.getTicker() + 1));
        }
    }

    public void checkupdates()
    {
        this.setHardner(false);
        this.setZapper(false);
        this.setCamouflage(false);

        for (int var1 = this.x - 1; var1 <= this.x + 1; ++var1)
        {
            for (int var2 = this.y - 1; var2 <= this.y + 1; ++var2)
            {
                for (int var3 = this.z - 1; var3 <= this.z + 1; ++var3)
                {
                    if (this.world.getTypeId(var1, var2, var3) == mod_ModularForceFieldSystem.MFFSUpgrades.id)
                    {
                        int var4 = this.world.getData(var1, var2, var3);
                        TileEntity var5 = this.world.getTileEntity(var1, var2, var3);

                        if (var5 != null)
                        {
                            if (((TileEntityPassivUpgrade)var5).getconectet_ID() == 0 && (var4 == 3 || var4 == 6 || var4 == 7))
                            {
                                ((TileEntityPassivUpgrade)var5).setconectet_ID(this.getProjektor_ID());
                                ((TileEntityPassivUpgrade)var5).setConnectet_typID((short)2);
                                this.world.k(var5.x, var5.y, var5.z);
                            }

                            if (var4 == 7 && ((TileEntityCamoflageUpgrade)var5).getItem_ID() != this.getTextur())
                            {
                                this.setTextur(((TileEntityCamoflageUpgrade)var5).getItem_ID());
                            }

                            if (((TileEntityPassivUpgrade)var5).getconectet_ID() == this.getProjektor_ID() && ((TileEntityPassivUpgrade)var5).getConnectet_typID() == 2)
                            {
                                if (((TileEntityPassivUpgrade)var5).getActive() != this.getActive())
                                {
                                    ((TileEntityPassivUpgrade)var5).setActive(this.getActive());
                                }

                                switch (var4)
                                {
                                    case 3:
                                        this.setHardner(true);

                                    case 4:
                                    case 5:
                                    default:
                                        break;

                                    case 6:
                                        this.setZapper(true);
                                        break;

                                    case 7:
                                        this.setCamouflage(true);
                                }
                            }
                        }
                    }
                }
            }
        }

        if (this.isZapper())
        {
            this.setffmeta((short)1);
        }
        else
        {
            this.setffmeta((short)0);
        }

        if (this.isCamouflage())
        {
            this.setffmeta((short)2);
        }
    }

    public void fieldcalculation(boolean var1)
    {
        if (!this.field_queue.isEmpty())
        {
            this.field_queue.clear();
        }

        int var2 = 0;
        int var3 = 0;
        int var4 = 0;

        for (int var5 = 0 - this.getlengthx(); var5 < this.getlengthx() + 1; ++var5)
        {
            for (int var6 = 0 - this.getlengthz(); var6 < this.getlengthz() + 1; ++var6)
            {
                if (this.getFacing() == 0)
                {
                    var3 = 0 - this.distance - 1;
                    var2 = var5;
                    var4 = var6;
                }

                if (this.getFacing() == 1)
                {
                    var3 = 0 + this.distance + 1;
                    var2 = var5;
                    var4 = var6;
                }

                if (this.getFacing() == 2)
                {
                    var4 = 0 - this.distance - 1;
                    var3 = var5;
                    var2 = var6;
                }

                if (this.getFacing() == 3)
                {
                    var4 = 0 + this.distance + 1;
                    var3 = var5;
                    var2 = var6;
                }

                if (this.getFacing() == 4)
                {
                    var2 = 0 - this.distance - 1;
                    var3 = var5;
                    var4 = var6;
                }

                if (this.getFacing() == 5)
                {
                    var2 = 0 + this.distance + 1;
                    var3 = var5;
                    var4 = var6;
                }

                this.hasher.setLength(0);
                this.hasher.append(this.x + var2).append("/").append(this.y + var3).append("/").append(this.z + var4);
                ForceFieldWorldMap var7 = WorldMap.getForceFieldforWorld(this.world).addandgetffmp(this.x + var2, this.y + var3, this.z + var4);
                boolean var8 = !this.world.getMaterial(this.x + var2, this.y + var3, this.z + var4).isBuildable();
                boolean var9 = this.world.getTypeId(this.x + var2, this.y + var3, this.z + var4) == mod_ModularForceFieldSystem.MFFSFieldblock.id;

                if (var9)
                {
                    var8 = true;
                }

                if (var7.listsize() == 0)
                {
                    if (this.getffmeta() == 2)
                    {
                        TexturworldMap.getTexturMap(Integer.valueOf(this.world.worldProvider.dimension)).add(this.x + var2, this.y + var3, this.z + var4, this.getTextur());
                    }

                    var7.ffworld_addFirst(new ForceFieldBlock(this.getLinkGenerator_ID(), this.getProjektor_ID(), var8, true, this.getffmeta()));
                    this.field_queue.add(this.hasher.toString());
                }
                else
                {
                    var7.ffworld_addLast(new ForceFieldBlock(this.getLinkGenerator_ID(), this.getProjektor_ID(), var8, false, this.getffmeta()));
                    this.field_queue.add(this.hasher.toString());
                }
            }
        }
    }

    public void destroyField()
    {
        Iterator var1 = this.field_queue.iterator();

        while (var1.hasNext())
        {
            String var2 = (String)var1.next();
            ForceFieldWorldMap var3 = WorldMap.getForceFieldforWorld(this.world).getFFWM(var2.toString());

            if (var3.listsize() >= 1)
            {
                if (var3.ffworld_getfirstfreespace() && var3.ffworld_getfistactive() && var3.ffworld_getfirstProjektor_ID() == this.getProjektor_ID())
                {
                    var3.ffworld_remove(this.getProjektor_ID());
                    this.world.setTypeId(var3.getX(), var3.getY(), var3.getZ(), 0);

                    if (var3.listsize() >= 1)
                    {
                        var3.ffworld_setfistactive(true);
                        var3.ffworld_setfirstfreeospace(false);
                    }
                }
                else
                {
                    var3.ffworld_remove(this.getProjektor_ID());
                }
            }
        }

        this.field_queue.clear();
    }

    /**
     * When some containers are closed they call this on each slot, then drop whatever it returns as an EntityItem -
     * like when you close a workbench GUI.
     */
    public ItemStack splitWithoutUpdate(int var1)
    {
        return null;
    }
}
