package mffs;

import forge.ISpecialResistance;
import forge.ITextureProvider;
import java.util.Random;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.BlockGlass;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.Material;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;
import net.minecraft.server.mod_ModularForceFieldSystem;

public class BlockForceField extends BlockGlass implements ITextureProvider, ISpecialResistance
{
    private boolean localFlag;
    private StringBuffer hasher = new StringBuffer();
    private int renderblockpass;

    public BlockForceField(int var1)
    {
        super(var1, var1, Material.SHATTERABLE, true);
        this.c(100000.0F);
        this.b(6000.0F);
        this.renderblockpass = 0;
        this.localFlag = false;
    }

    public int getRenderBlockPass()
    {
        return this.renderblockpass;
    }

    /**
     * Called whenever the block is removed.
     */
    public void remove(World var1, int var2, int var3, int var4)
    {
        if (!var1.isStatic)
        {
            this.hasher.setLength(0);
            this.hasher.append(var2).append("/").append(var3).append("/").append(var4);
            ForceFieldWorldMap var5 = WorldMap.getForceFieldforWorld(var1).getFFWM(this.hasher.toString());

            if (var5 != null && var5.listsize() >= 1 && var5.ffworld_getfistactive())
            {
                var5.ffworld_setfirstfreeospace(true);
                var5.setsync(false);
                var1.setRawTypeId(var2, var3, var4, mod_ModularForceFieldSystem.MFFSFieldblock.id);
                TileEntity var6 = (TileEntity)Linkgrid.getWorldMap(var1).getGenerator().get(Integer.valueOf(var5.ffworld_getfirstGenerator_ID()));

                if (var6 instanceof TileEntityGeneratorCore && var6 != null)
                {
                    if (var5.ffworld_getfistmode() == 1)
                    {
                        ((TileEntityGeneratorCore)var6).Energylost(mod_ModularForceFieldSystem.forcefieldblockcost * mod_ModularForceFieldSystem.forcefieldblockcreatemodifier);
                    }
                    else
                    {
                        ((TileEntityGeneratorCore)var6).Energylost(mod_ModularForceFieldSystem.forcefieldblockcost * mod_ModularForceFieldSystem.forcefieldblockcreatemodifier * mod_ModularForceFieldSystem.forcefieldblockzappermodifier);
                    }
                }
            }
        }
    }

    /**
     * Returns a bounding box from the pool of bounding boxes (this means this box can change after the pool has been
     * cleared to be reused)
     */
    public AxisAlignedBB e(World var1, int var2, int var3, int var4)
    {
        if (var1.getData(var2, var3, var4) == 1)
        {
            float var5 = 0.0625F;
            return AxisAlignedBB.b((double)((float)var2 + var5), (double)var3, (double)((float)var4 + var5), (double)((float)(var2 + 1) - var5), (double)((float)(var3 + 1) - var5), (double)((float)(var4 + 1) - var5));
        }
        else
        {
            return AxisAlignedBB.b((double)((float)var2), (double)var3, (double)((float)var4), (double)((float)(var2 + 1)), (double)((float)(var3 + 1)), (double)((float)(var4 + 1)));
        }
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World var1, int var2, int var3, int var4)
    {
        if (var1.getData(var2, var3, var4) == 1)
        {
            float var5 = 0.0625F;
            return AxisAlignedBB.b((double)((float)var2 + var5), (double)var3, (double)((float)var4 + var5), (double)((float)(var2 + 1) - var5), (double)(var3 + 1), (double)((float)(var4 + 1) - var5));
        }
        else
        {
            return AxisAlignedBB.b((double)((float)var2), (double)var3, (double)((float)var4), (double)((float)(var2 + 1)), (double)(var3 + 1), (double)((float)(var4 + 1)));
        }
    }

    /**
     * Triggered whenever an entity collides with this block (enters into the block). Args: world, x, y, z, entity
     */
    public void a(World var1, int var2, int var3, int var4, Entity var5)
    {
        if (!var1.isStatic && var1.getData(var2, var3, var4) == 1 && var5 instanceof EntityLiving)
        {
            var5.damageEntity(DamageSource.OUT_OF_WORLD, 5);
        }
    }

    /**
     * Returns the quantity of items to drop on block destruction.
     */
    public int a(Random var1)
    {
        return 0;
    }

    public String getTextureFile()
    {
        return "/mffs_grafik/blocks.png";
    }

    /**
     * Called upon block activation (left or right click on the block.). The three integers represent x,y,z of the
     * block.
     */
    public boolean interact(World var1, int var2, int var3, int var4, EntityHuman var5)
    {
        return false;
    }

    public float getSpecialExplosionResistance(World var1, int var2, int var3, int var4, double var5, double var7, double var9, Entity var11)
    {
        if (!var1.isStatic)
        {
            this.hasher.setLength(0);
            this.hasher.append(var2).append("/").append(var3).append("/").append(var4);
            ForceFieldWorldMap var12 = WorldMap.getForceFieldforWorld(var1).getFFWM(this.hasher.toString());

            if (var12 != null && var12.listsize() >= 1 && var12.ffworld_getfistactive())
            {
                TileEntity var13 = (TileEntity)Linkgrid.getWorldMap(var1).getGenerator().get(Integer.valueOf(var12.ffworld_getfirstGenerator_ID()));

                if (var13 instanceof TileEntityGeneratorCore && var13 != null)
                {
                    ((TileEntityGeneratorCore)var13).Energylost(mod_ModularForceFieldSystem.forcefieldblockcost * mod_ModularForceFieldSystem.forcefieldblockcreatemodifier);
                }
            }
        }

        return 60000.0F;
    }

    public void randomDisplayTick(World var1, int var2, int var3, int var4, Random var5)
    {
        if (var1.getData(var2, var3, var4) == 1)
        {
            double var6 = (double)((float)var2 + 0.5F);
            double var8 = (double)((float)var3 + 0.5F);
            double var10 = (double)((float)var4 + 0.5F);
            var1.a("reddust", var6, var8, var10, 0.0D, 0.0D, 0.0D);
        }
    }

    public boolean canConnectRedstone(IBlockAccess var1, int var2, int var3, int var4, int var5)
    {
        return false;
    }
}
