package immibis.lxp;

import immibis.core.BlockCombined;
import immibis.core.api.util.Dir;

import java.util.ArrayList;

import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class LXPMachineBlock extends BlockCombined {

	public LXPMachineBlock(int i) {
		super(i, Material.iron, "/immibis/lxp/world.png");
	}

	@Override
	public int getBlockTextureFromSideAndMetadata(int side, int data) {
		switch(data) {
		case LXPMachineItem.META_COLLECTOR: return 16;
		case LXPMachineItem.META_ABSORBER: return side == Dir.PY ? 17 : 20;
		case LXPMachineItem.META_CATALYZER: return 18;
		case LXPMachineItem.META_IMPRINTER: return side == Dir.PY || side == Dir.NY ? 24 : 19;
		case LXPMachineItem.META_ENCHANTER:
			if(side == Dir.PZ)
				return 29;
			if(side == Dir.PY)
				return 26;
			if(side == Dir.NY)
				return 27;
			return 28;
		case LXPMachineItem.META_COMBINER:
			if(side == Dir.PY || side == Dir.NY)
				return 25;
			if(side == Dir.NZ)
				return 24;
			if(side == Dir.PZ)
				return 23;
			return 22;
		}
		return 0;
	}
	
	@Override
	@SideOnly(Side.CLIENT)
	public int getBlockTexture(IBlockAccess w, int x, int y, int z, int side) {
		TileEntity te = w.getBlockTileEntity(x, y, z);
		if(te instanceof EnchanterTile) {
			int front = ((EnchanterTile)te).front;
			if(side == front)
				return 29;
			if(side == Dir.PY)
				return 26;
			if(side == Dir.NY)
				return 27;
			return 28;
		}
		if(te instanceof CombinerTile) {
			int front = ((CombinerTile)te).front;
			if(side == front)
				return 23;
			if(side == (front ^ 1))
				return 24;
			if(side == Dir.PY || side == Dir.NY)
				return 25;
			return 22;
		}
		
		return super.getBlockTexture(w, x, y, z, side);
	}

	@Override
	public TileEntity getBlockEntity(int data) {
		switch(data) {
		case LXPMachineItem.META_COLLECTOR: return new CollectorTile();
		case LXPMachineItem.META_ABSORBER: return new AbsorberTile();
		case LXPMachineItem.META_CATALYZER: return new CatalyzerTile();
		case LXPMachineItem.META_IMPRINTER: return new ImprinterTile();
		case LXPMachineItem.META_ENCHANTER: return new EnchanterTile();
		case LXPMachineItem.META_COMBINER: return new CombinerTile();
		}
		return null;
	}

	@SuppressWarnings({"rawtypes","unchecked"})
	@Override
	public void addCreativeItems(ArrayList arraylist) {
		arraylist.add(new ItemStack(this, 1, LXPMachineItem.META_COLLECTOR));
		arraylist.add(new ItemStack(this, 1, LXPMachineItem.META_ABSORBER));
		arraylist.add(new ItemStack(this, 1, LXPMachineItem.META_CATALYZER));
		arraylist.add(new ItemStack(this, 1, LXPMachineItem.META_IMPRINTER));
		arraylist.add(new ItemStack(this, 1, LXPMachineItem.META_ENCHANTER));
		arraylist.add(new ItemStack(this, 1, LXPMachineItem.META_COMBINER));
	}

}
