package mods.immibis.infinitubes;

import mods.immibis.core.api.util.BaseGuiContainer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class TransporterGui extends BaseGuiContainer<TransporterContainer> {
	public TransporterGui(TransporterContainer container) {
		super(container, 186, 212, R.gui.teleposer);
	}
	
	private void drawSideColour(int x, int y, int side) {
		int u = 198 + (side % 2) * 16;
		int v = 34 + (side / 2) * 16;
		drawTexturedModalRect(x+guiLeft, y+guiTop, u, v, 12, 12);
	}
	
	private GuiTextField txtInLabel, txtOutLabel;
	private GuiButton btnInvert, btnPowerBridge;
	
	@SuppressWarnings("unchecked")
	@Override
	public void initGui() {
		super.initGui();
		
		buttonList.add(new GuiButton(4, guiLeft+8, guiTop+84, 20, 20, "+"));
		buttonList.add(new GuiButton(5, guiLeft+30, guiTop+84, 20, 20, "-"));
		
		btnInvert = new GuiButton(6, guiLeft+85, guiTop+3, 89, 14, I18n.format("gui.infinitubes.teleposer.inverted.no"));
		buttonList.add(btnInvert);
		
		btnPowerBridge = new GuiButton(7, guiLeft+8, guiTop+106, 170, 20, I18n.format("gui.infinitubes.teleposer.bridge.no"));
		buttonList.add(btnPowerBridge);
		
		txtInLabel  = new GuiTextField(fontRendererObj, guiLeft+44, guiTop+44, 130, 16);
		txtOutLabel = new GuiTextField(fontRendererObj, guiLeft+44, guiTop+66, 130, 16);
		
		txtInLabel.setMaxStringLength(256);
		txtOutLabel.setMaxStringLength(256);
		
		txtInLabel.setText(container.getInv().inLabel);
		txtOutLabel.setText(container.getInv().outLabel);
	}
	
	private void sendLabels() {
		TransporterGuiUpdatePacket p = new TransporterGuiUpdatePacket();
		p.inLabel = txtInLabel.getText();
		p.outLabel = txtOutLabel.getText();
		container.sendActionPacket(p);
	}
	
	@Override
	protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3) {
		
		btnInvert.displayString = I18n.format("gui.infinitubes.teleposer.inverted."+(container.invertFilter?"yes":"no"));
		btnPowerBridge.displayString = I18n.format("gui.infinitubes.teleposer.bridge."+(container.powerBridge?"yes":"no"));
		
		super.drawGuiContainerBackgroundLayer(var1, var2, var3);
		
		drawSideColour(29, 46, container.inputSide);
		drawSideColour(29, 68, container.outputSide);
		
		int textColour = 0xFFFFFF;
		
		drawString(I18n.format("gui.infinitubes.teleposer.filter"), 11, 5, textColour);
		drawString(I18n.format("gui.infinitubes.teleposer.in"), 8, 48, textColour);
		drawString(I18n.format("gui.infinitubes.teleposer.out"), 8, 70, textColour);
		
		drawString(I18n.format("gui.infinitubes.teleposer.priority", container.priority), 52, 89, textColour);
		
		txtInLabel.drawTextBox();
		txtOutLabel.drawTextBox();
	}
	
	@Override
	protected void mouseClicked(int par1, int par2, int par3) {
		int x = par1 - guiLeft, y = par2 - guiTop;
		if(x >= 29 && y >= 46 && x < 41 && y < 58) {
			if(par3 == 0)
				container.sendButtonPressed(0); // input++
			else if(par3 == 1)
				container.sendButtonPressed(1); // input--
		}
		if(x >= 29 && y >= 68 && x < 41 && y < 80) {
			if(par3 == 0)
				container.sendButtonPressed(2); // output++
			else if(par3 == 1)
				container.sendButtonPressed(3); // output--
		}
		super.mouseClicked(par1, par2, par3);
		txtInLabel.mouseClicked(par1, par2, par3);
		txtOutLabel.mouseClicked(par1, par2, par3);
	}
	
	@Override
	protected void actionPerformed(GuiButton par1GuiButton) {
		container.sendButtonPressed(par1GuiButton.id);
	}
	
	private boolean textboxDirty = false;
	
	@Override
	protected void keyTyped(char par1, int par2) {
		if(txtInLabel.isFocused())
			if(txtInLabel.textboxKeyTyped(par1, par2)) {
				textboxDirty = true;
				return;
			}
		if(txtOutLabel.isFocused())
			if(txtOutLabel.textboxKeyTyped(par1, par2)) {
				textboxDirty = true;
				return;
			}
		if(textboxDirty) {
			textboxDirty = false;
			sendLabels();
		}
		super.keyTyped(par1, par2);
	}
}
