package mods.immibis.infinitubes;

import net.minecraft.nbt.NBTTagCompound;
import mods.immibis.core.api.traits.IEnergyConsumerTrait;
import mods.immibis.core.api.traits.IEnergyConsumerTrait.EnergyUnit;
import mods.immibis.core.api.traits.IEnergyConsumerTraitUser;
import mods.immibis.core.api.traits.TraitField;
import mods.immibis.core.api.traits.UsesTraits;
import mods.immibis.core.api.util.Dir;

@UsesTraits
public class PowerJunctionTile extends MachineTileBase implements IEnergyConsumerTraitUser {
	
	@TraitField
	public IEnergyConsumerTrait energyConsumer;

	public PowerJunctionTile() {
		super(0, "");
	}
	
	protected WorldTubeMap.TubeNet getNet() {
		return WorldTubeMap.getForWorld(worldObj).getNet(xCoord, yCoord + 1, zCoord);
	}
	
	@Override
	public boolean connectsOnSide(int i) {
		return i == Dir.PY;
	}
	
	private static final double RATIO = 2; // EU per item

	@Override
	public EnergyUnit EnergyConsumer_getPreferredUnit() {
		return EnergyUnit.EU;
	}

	@Override
	public double EnergyConsumer_getPreferredBufferSize() {
		return 1024;
	}

	@Override
	public boolean EnergyConsumer_isBufferingPreferred() {
		return false;
	}
	
	@Override
	public void readFromNBT(NBTTagCompound nbttagcompound) {
		super.readFromNBT(nbttagcompound);
		energyConsumer.readFromNBT(nbttagcompound);
	}
	
	@Override
	public void writeToNBT(NBTTagCompound nbttagcompound) {
		super.writeToNBT(nbttagcompound);
		energyConsumer.writeToNBT(nbttagcompound);
	}
	
	@Override
	public void updateEntity() {
		super.updateEntity();
		
		if(worldObj.isRemote)
			return;
		
		WorldTubeMap.TubeNet net = getNet();
		if(net == null)
			return;
		
		int energySpaceInNet = net.maxStoredPower() - net.storedPower;
		int energyAvailable = (int)(energyConsumer.getStoredEnergy() / RATIO);
		int energyUsed = Math.min(energySpaceInNet, energyAvailable);
		if(energyUsed > 0) {
			double euUsed = energyUsed * RATIO;
			euUsed = energyConsumer.useEnergy(euUsed, euUsed);
			getNet().storedPower += (int)(euUsed / RATIO);
		}
	}

}
