package mods.immibis.infinitubes;

import java.util.List;

import mods.immibis.core.TileBasicInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;

public class MachineTileBase extends TileBasicInventory {
	public MachineTileBase(int invSize, String invname) {
		super(invSize, invname);
	}

	public boolean connectsOnSide(int i) {
		return false;
	}
	
	@SuppressWarnings("unchecked")
	public void explodeFromLag() {
		if(worldObj.isRemote)
			return;
		
		for(EntityPlayer pl : (List<EntityPlayer>)worldObj.playerEntities) {
			if(pl.getDistanceSq(xCoord+0.5, yCoord+0.5, zCoord+0.5) <= 64)
				pl.addChatMessage(new ChatComponentText("infinitubes.lagwarning"));
		}
		
		worldObj.newExplosion(null, xCoord+0.5, yCoord+0.5, zCoord+0.5, 0.0f, false, false);
		worldObj.setBlockToAir(xCoord, yCoord, zCoord);
	}
}
