package mods.immibis.infinitubes;


import mods.immibis.core.BlockCombined;
import mods.immibis.core.api.util.Dir;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class MachineBlock extends BlockCombined {
	public MachineBlock() {
		super(Material.iron);
		
		setCreativeTab(CreativeTabs.tabTransport);
	}
	
	public IIcon[] iTeleposerIn = new IIcon[6];
	public IIcon[] iTeleposerOut = new IIcon[6];
	public IIcon[] iTeleposerSide = new IIcon[6];
	public IIcon[] iDislocatorIn = new IIcon[6];
	public IIcon[] iDislocatorSide = new IIcon[6];
	public IIcon iPowerTop, iPowerBottom, iPowerSide;
	
	@Override
	@SideOnly(Side.CLIENT)
	public void registerBlockIcons(IIconRegister reg) {
		for(int k = 0; k < 6; k++) {
			iTeleposerIn[k] = reg.registerIcon(R.block.t_in+k);
			iTeleposerOut[k] = reg.registerIcon(R.block.t_out+k);
			iTeleposerSide[k] = reg.registerIcon(R.block.t_side+k);
			iDislocatorIn[k] = reg.registerIcon(R.block.d_in+k);
			iDislocatorSide[k] = reg.registerIcon(R.block.d_side+k);
		}
		iPowerBottom = reg.registerIcon(R.block.p_bottom);
		iPowerTop = reg.registerIcon(R.block.p_top);
		iPowerSide = reg.registerIcon(R.block.p_side);
	}

	@Override
	public IIcon getIcon(int side, int data) {
		if(data == 0) {
			return iTeleposerSide[side];
		} else if(data == 1) {
			// power junction
			if(side == Dir.PY)
				return iPowerTop;
			else if(side == Dir.NY)
				return iPowerBottom;
			else
				return iPowerSide;
		} else if(data == 2) {
			return iDislocatorSide[side];
		}
		return null;
	}
	
	@Override
	public IIcon getIcon(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
		TileEntity te = par1iBlockAccess.getTileEntity(par2, par3, par4);
		if(te instanceof TransporterTile) {
			TransporterTile tt = (TransporterTile)te;
			if(par5 == tt.inputSide)
				return iTeleposerIn[par5];
			else if(par5 == tt.outputSide)
				return iTeleposerOut[par5];
			else
				return iTeleposerSide[par5];
		}
		if(te instanceof PowerJunctionTile) {
			if(par5 == Dir.PY)
				return iPowerTop;
			else if(par5 == Dir.NY)
				return iPowerBottom;
			else
				return iPowerSide;
		}
		if(te instanceof DislocatorTile) {
			if(par5 == ((DislocatorTile)te).facing)
				return iDislocatorIn[par5];
			else
				return iDislocatorSide[par5];
		}
		return null;
	}

	@Override
	public TileEntity getBlockEntity(int data) {
		try {
			switch(data) {
			case 0: return new TransporterTile();
			case 1: return new PowerJunctionTile();
			case 2: return new DislocatorTile();
			default: return null;
			}
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public void getCreativeItems(java.util.List<ItemStack> arraylist) {
		arraylist.add(new ItemStack(this, 1, 0));
		arraylist.add(new ItemStack(this, 1, 1));
		arraylist.add(new ItemStack(this, 1, 2));
	}
	
	@Override
	public void onBlockAdded(World world, int x, int y, int z) {
		super.onBlockAdded(world, x, y, z);
		WorldTubeMap.getForWorld(world).addMachine(x, y, z);
	}
	
	@Override
	public void breakBlock(World world, int x, int y, int z, Block blockID, int meta) {
		WorldTubeMap.getForWorld(world).removeMachine(x, y, z);
		super.breakBlock(world, x, y, z, blockID, meta);
	}
	
	@Override
	public boolean isBlockNormalCube() {
		return true;
	}
}
