package mods.immibis.infinitubes;


import java.util.Collections;
import java.util.List;

import mods.immibis.microblocks.api.EnumPosition;
import mods.immibis.microblocks.api.EnumPositionClass;
import mods.immibis.microblocks.api.PartType;
import mods.immibis.microblocks.api.util.TileCoverableBase;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.util.ForgeDirection;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class InfiniTubeTile extends TileCoverableBase {
	
	@Override public boolean canUpdate() {return false;}
	
	

	@Override
	public boolean isPlacementBlockedByTile(PartType<?> type, EnumPosition pos) {
		return pos.clazz == EnumPositionClass.Post || type.getSize() > 0.25;
	}

	@Override
	public boolean isPositionOccupiedByTile(EnumPosition pos) {
		return pos == EnumPosition.Centre;
	}

	@Override
	public EnumPosition getPartPosition(int subHit) {
		return EnumPosition.Centre;
	}

	@Override
	public AxisAlignedBB getPartAABBFromPool(int subHit) {
		return AxisAlignedBB.getBoundingBox(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
	}

	@Override
	protected int getNumTileOwnedParts() {
		return 1;
	}

	@Override
	public float getPlayerRelativePartHardness(EntityPlayer ply, int part) {
		return ply.getCurrentPlayerStrVsBlock(InfiniTubes.tube, false) / InfiniTubeBlock.HARDNESS / 30F;
	}

	@Override
	public ItemStack pickPart(MovingObjectPosition rayTrace, int part) {
		return new ItemStack(InfiniTubes.tube, 1, 0);
	}

	@Override
	public boolean isSolidOnSide(ForgeDirection side) {
		return false;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void render(RenderBlocks render) {
		InfiniTubeStaticRenderer.INSTANCE.renderWorldBlock(render, worldObj, xCoord, yCoord, zCoord, InfiniTubes.tube, 0);
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void renderPart(RenderBlocks render, int part) {
		InfiniTubeStaticRenderer.INSTANCE.renderWorldBlock(render, worldObj, xCoord, yCoord, zCoord, InfiniTubes.tube, 0);
	}

	@Override
	public List<ItemStack> removePartByPlayer(EntityPlayer ply, int part) {
		if(cover != null)
			cover.convertToContainerBlock();
		else
			worldObj.setBlock(xCoord, yCoord, zCoord, Blocks.air, 0, 2);
		return Collections.singletonList(new ItemStack(InfiniTubes.tube, 1, 0));
	}
	
	

}
