package mods.immibis.infinitubes;

import mods.immibis.core.api.util.Dir;
import mods.immibis.microblocks.api.MicroblockAPIUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class InfiniTubeItem extends ItemBlock {

	public InfiniTubeItem(Block block) {
		super(block);
	}
	
	@Override
	public boolean onItemUse(ItemStack stack, EntityPlayer ply, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
		Block oldBlockID = w.getBlock(x, y, z);
		Block microblockContainerBlock = MicroblockAPIUtils.getMicroblockContainerBlock();
		if(
			(microblockContainerBlock == null || oldBlockID != microblockContainerBlock)
			&& oldBlockID != Blocks.air && !oldBlockID.isReplaceable(w, x, y, z)) {
			switch(side) {
			case Dir.NX: x--; break;
			case Dir.PX: x++; break;
			case Dir.NY: y--; break;
			case Dir.PY: y++; break;
			case Dir.NZ: z--; break;
			case Dir.PZ: z++; break;
			}
			if(!w.blockExists(x, y, z))
				return false;
			
			oldBlockID = w.getBlock(x, y, z);
			
			if(oldBlockID != Blocks.air && !oldBlockID.isReplaceable(w, x, y, z))
				return false;
		}
		
		if(microblockContainerBlock != null && oldBlockID == microblockContainerBlock) {
			if(!w.isRemote)
				if(MicroblockAPIUtils.mergeIntoMicroblockContainer(stack, ply, w, x, y, z, side, Block.getBlockFromItem(this), 0))
					stack.stackSize--;
			return true;
		}
		
		w.setBlock(x, y, z, Block.getBlockFromItem(this), 0, 3);
		stack.stackSize--;
		return true;
	}
	
	@Override
	public boolean func_150936_a(World par1World, int par2, int par3, int par4, int par5, EntityPlayer par6EntityPlayer, ItemStack par7ItemStack) {
		return true;
	}

}
