package mods.immibis.infinitubes;


import java.util.List;

import mods.immibis.core.RenderUtilsIC;
import mods.immibis.core.api.multipart.util.BlockMultipartBase;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class InfiniTubeBlock extends BlockMultipartBase {
	public static Material material = new Material(MapColor.ironColor) {{
		setImmovableMobility();
	}};
	
	public static final float HARDNESS = 0.25f;
	
	public InfiniTubeBlock() {
		super(material);

		setCreativeTab(CreativeTabs.tabTransport);
		
		setBlockName("infinitubes.conduit");
	}
	
	static IIcon iStraight, iJunction;
	
	@Override
	@SideOnly(Side.CLIENT)
	public void registerBlockIcons(IIconRegister par1IconRegister) {
		iStraight = RenderUtilsIC.loadIcon(par1IconRegister, R.block.conduit);
		iJunction = RenderUtilsIC.loadIcon(par1IconRegister, R.block.conduitJunction);
	}
	
	public static boolean connects(IBlockAccess w, int x, int y, int z, int tubeSide) {
		Block block = w.getBlock(x, y, z);
		if(block == InfiniTubes.tube)
			return true;
		if(block == InfiniTubes.machines) {
			MachineTileBase mt = (MachineTileBase)w.getTileEntity(x, y, z);
			return mt.connectsOnSide(tubeSide ^ 1);
		}
		return false;
	}
	
	@Override
	public TileEntity createNewTileEntity(World world, int metadata) {
		return new InfiniTubeTile();
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
		par3List.add(new ItemStack(this, 1, 0));
	}
	
	@Override
	public void onBlockAdded(World world, int x, int y, int z) {
		super.onBlockAdded(world, x, y, z);
		WorldTubeMap.getForWorld(world).addTube(x, y, z);
	}
	
	@Override
	public void breakBlock(World world, int x, int y, int z, Block blockID, int meta) {
		WorldTubeMap.getForWorld(world).removeTube(x, y, z);
		super.breakBlock(world, x, y, z, blockID, meta);
	}
	
	@Override
	@SideOnly(Side.CLIENT)
	public void renderInvBlock(RenderBlocks render, int meta) {
		InfiniTubeStaticRenderer.INSTANCE.renderInvBlock(render, this, meta, 0);
	}
}
