package mods.immibis.infinitubes;


import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import mods.immibis.core.net.AbstractContainerSyncPacket;

public class DislocatorGuiUpdatePacket extends AbstractContainerSyncPacket {
	public String label;
	public String filter;

	@Override
	public byte getID() {
		return InfiniTubes.PKT_DISLOCATOR_GUI;
	}

	@Override
	public String getChannel() {
		return InfiniTubes.CHANNEL;
	}

	@Override
	public void read(DataInputStream in) throws IOException {
		label = in.readUTF();
		filter = in.readUTF();
	}

	@Override
	public void write(DataOutputStream out) throws IOException {
		out.writeUTF(label);
		out.writeUTF(filter);
	}
}
