package mods.immibis.infinitubes;


import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

import mods.immibis.core.ImmibisCore;
import mods.immibis.core.api.util.Dir;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TransporterTile extends MachineTileBase implements ISidedInventory, IItemReceptor, IDislocatable {
	public int inputSide = Dir.PX;
	public int outputSide = Dir.NX;
	public int priority = 500;
	
	public boolean invertFilter = false;
	
	public TransporterTile() {
		super(9, "Transporter");
	}
	
	@Override
	public void readFromNBT(NBTTagCompound tag) {
		inputSide = tag.getInteger("input");
		outputSide = tag.getInteger("output");
		inLabel = tag.getString("inL");
		outLabel = tag.getString("outL");
		priority = tag.getInteger("prio");
		invertFilter = tag.getBoolean("invert");
		
		inFilter = null;
		
		super.readFromNBT(tag);
	}
	
	@Override
	public void writeToNBT(NBTTagCompound tag) {
		tag.setInteger("input", inputSide);
		tag.setInteger("output", outputSide);
		tag.setString("inL", inLabel);
		tag.setString("outL", outLabel);
		tag.setInteger("prio", priority);
		tag.setBoolean("invert", invertFilter);
		super.writeToNBT(tag);
	}
	
	@Override
	public Packet getDescriptionPacket() {
		Packet132TileEntityData p = new Packet132TileEntityData(xCoord, yCoord, zCoord, 0, new NBTTagCompound());
		p.customParam1.setByte("S", (byte)((inputSide << 3) | outputSide));
		p.customParam1.setString("I", inLabel);
		p.customParam1.setString("O", outLabel);
		return p;
	}
	
	@Override
	public void onDataPacket(Packet132TileEntityData packet) {
		byte s = packet.customParam1.getByte("S");
		inputSide = s >> 3;
		outputSide = s & 7;
		inLabel = packet.customParam1.getString("I");
		outLabel = packet.customParam1.getString("O");
		worldObj.markBlockForUpdate(xCoord, yCoord, zCoord);
	}
	
	private int timer = 0;
	public String inLabel = "", outLabel = "";
	public LabelParser.Predicate inFilter = null;
	
	private int inSlot = 0;
	
	private IInventory getInputInventory() {
		return InventoryHelper.getInventoryOnSide(worldObj, xCoord, yCoord, zCoord, inputSide);
	}
	private IInventory getOutputInventory() {
		return InventoryHelper.getInventoryOnSide(worldObj, xCoord, yCoord, zCoord, outputSide);
	}
	
	/*private int hasOutputInventory = -1;
	private boolean hasOutputInventory() {
		if(hasOutputInventory == -1) {
			hasOutputInventory = getOutputInventory() != null ? 1 : 0;
		}
		return hasOutputInventory == 1;
	}
	
	@Override
	public void onBlockNeighbourChange() {
		super.onBlockNeighbourChange();
		hasOutputInventory = -1;
	}*/
	
	@Override
	public void updateEntity() {
		if(timer++ < 20)
			return;
		timer = 0;
		
		IInventory in = getInputInventory();
		if(in == null)
			return;
		
		IRestrictedInventory inR = (in instanceof IRestrictedInventory ? (IRestrictedInventory)in : null);
		
		int inSize = in.getSizeInventory();
		
		if(inSize <= 0)
			return;
		
		int thisInSlot = -1;
		
		for(int k = 0; k < inSize; k++) {
			inSlot = (inSlot + 1) % inSize;
			ItemStack inStack = in.getStackInSlot(inSlot);
			if(inStack != null && (inR == null || inR.canExtract(inSlot)) && itemMatchesItemFilter(inStack)) {
				thisInSlot = inSlot;
				break;
			}
		}
		if(thisInSlot < 0)
			return;
		
		StackPointer from = new StackPointer(in, thisInSlot);
		
		ItemStack stack = from.get();
		try {
			pushItemToAnyOutput(stack, new Operation());
		} catch(Operation.DontCauseLagException e) {
			explodeFromLag();
		}
		from.put(stack.stackSize == 0 ? null : stack);
	}
	
	private static class ItemTarget {
		IItemReceptor receptor;
		ForgeDirection side;
		ItemTarget(IItemReceptor r, ForgeDirection s) {
			receptor = r;
			side = s;
		}
		@Override
		public int hashCode() {
			return receptor.hashCode() + side.ordinal();
		}
		@Override
		public boolean equals(Object obj) {
			try {
				ItemTarget o = (ItemTarget)obj;
				return receptor == o.receptor && side == o.side;
			} catch(ClassCastException e) {
				return false;
			}
		}
		@Override
		public String toString() {
			return receptor + ":" + side.ordinal();
		}
	}
	
	@Override
	public String toString() {
		return "[" + xCoord + "," + yCoord + "," + zCoord + "]";
	}
	
	private static final Comparator<ItemTarget> PRIORITY_COMPARATOR = new Comparator<ItemTarget>() {
		@Override
		public int compare(ItemTarget a, ItemTarget b) {
			int priorityDiff = b.receptor.getItemReceptorPriority() - a.receptor.getItemReceptorPriority();
			if(priorityDiff != 0)
				return priorityDiff;
			return a.hashCode() - b.hashCode();
		}
	};
	
	private static void pushItemToNet(World world, ItemStack stack, WorldTubeMap.TubeNet net, String label, Operation op) throws Operation.DontCauseLagException {
		SortedSet<ItemTarget> receptors = new TreeSet<ItemTarget>(PRIORITY_COMPARATOR);
		for(Map.Entry<WorldTubeMap.XYZ, ForgeDirection> e : net.machineSides.entries()) {
			WorldTubeMap.XYZ xyz = e.getKey();
			if(world.blockExists(xyz.x, xyz.y, xyz.z)) {
				TileEntity te = world.getBlockTileEntity(xyz.x, xyz.y, xyz.z);
				if(te instanceof IItemReceptor) {
					ItemTarget target = new ItemTarget((IItemReceptor)te, e.getValue());
					receptors.add(target);
				}
			}
		}
		for(ItemTarget t : receptors) {
			t.receptor.insert(stack, t.side, label, op);
			if(stack.stackSize <= 0)
				break;
		}
	}
	
	private void pushItemToAnyOutput(ItemStack stack, Operation op) throws Operation.DontCauseLagException {
		if(pushItemToOutputInventory(stack, op))
			return;
		
		pushItemToTubesInDirection(stack, outputSide, outLabel, op);
	}
	
	private void pushItemToTubesInDirection(ItemStack stack, int direction, String label, Operation op) throws Operation.DontCauseLagException {
		op.countMethodCall();
		
		ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[direction];
		int x = xCoord + fd.offsetX, y = yCoord + fd.offsetY, z = zCoord + fd.offsetZ;
		if(worldObj.getBlockId(x, y, z) == InfiniTubes.tube.blockID) {
			WorldTubeMap.TubeNet net = WorldTubeMap.getForWorld(worldObj).getNet(x, y, z);
			if(net != null) {
				
				if(InfiniTubes.usePower) {
					if(net.storedPower < stack.stackSize + 3)
						return;
					net.storedPower -= stack.stackSize + 3;
				}
				
				for(String s : label.split(",")) {
					pushItemToNet(worldObj, stack, net, s, op);
					if(stack.stackSize <= 0)
						break;
				}
				
				if(InfiniTubes.usePower) {
					net.storedPower += stack.stackSize;
					WorldTubeMap.getForWorld(worldObj).setDirty(true);
				}
			}
		}
	}
	
	// returns false if no inventory on output side
	/*private boolean pushItemToOutputInventory(StackPointer ptr) {
		ItemStack stack = ptr.inv.getStackInSlot(ptr.slot);
		if(!pushItemToOutputInventory(stack))
			return false;
		ptr.inv.setInventorySlotContents(ptr.slot, stack.stackSize <= 0 ? null : stack);
		return true;
	}*/
	private boolean pushItemToOutputInventory(ItemStack inStack, Operation op) {
		IInventory out = getOutputInventory();
		if(out == null)
			return false;
		
		IRestrictedInventory outR = (out instanceof IRestrictedInventory ? (IRestrictedInventory)out : null);
		
		int outLimit = out.getInventoryStackLimit();
		
		int outSize = out.getSizeInventory();
		if(inStack == null)
			return true;
		
		int stackMax = Math.min(outLimit, inStack.getMaxStackSize());
		
		int firstEmpty = -1;
		for(int outSlot = 0; outSlot < outSize; outSlot++) {
			ItemStack outStack = out.getStackInSlot(outSlot);
			if(outStack == null) {
				if(firstEmpty == -1 && (outR == null || outR.canInsert(outSlot, inStack)))
					firstEmpty = outSlot;
				continue;
			}
			
			if(ImmibisCore.areItemsEqual(inStack, outStack) && out.isStackValidForSlot(outSlot, inStack) && (outR == null || outR.canInsert(outSlot, inStack))) {
				int amt = Math.min(stackMax - outStack.stackSize, inStack.stackSize);
				if(amt > 0) {
					outStack.stackSize += amt;
					inStack.stackSize -= amt;
					out.setInventorySlotContents(outSlot, outStack);
					if(inStack.stackSize == 0) {
						inStack = null;
						break;
					}
				}
			}
		}
		
		if(inStack != null && firstEmpty >= 0) {
			// this should respect inventoryStackLimit, but doesn't.
			out.setInventorySlotContents(firstEmpty, inStack.copy());
			inStack.stackSize = 0;
		}
		
		return true;
	}
	
	@Override
	public boolean onBlockActivated(EntityPlayer player) {
		if(!worldObj.isRemote)
			player.openGui(InfiniTubes.instance, InfiniTubes.GUI_TRANSPORTER, worldObj, xCoord, yCoord, zCoord);
		return true;
	}
	
	
	private static int[] NO_SLOTS = new int[0];
	@Override
	public int[] getAccessibleSlotsFromSide(int var1) {
		return NO_SLOTS;
	}

	@Override
	public boolean canInsertItem(int i, ItemStack itemstack, int j) {
		return false;
	}

	@Override
	public boolean canExtractItem(int i, ItemStack itemstack, int j) {
		return false;
	}
	
	
	private boolean itemMatchesItemFilter(ItemStack stack) {
		boolean anyFilters = false;
		for(int k = 0; k < 9; k++) {
			if(inv.contents[k] == null)
				continue;
			anyFilters = true;
			if(ImmibisCore.areItemsEqual(inv.contents[k], stack))
				return !invertFilter; // return true ^ invertFilter;
		}
		return !anyFilters ^ invertFilter;
	}
	
	
	private boolean recursive = false;

	@Override
	public void insert(ItemStack stack, ForgeDirection side, String label, Operation op) throws Operation.DontCauseLagException {
		if(recursive)
			return;
		
		if(side.ordinal() != inputSide) {
			//System.out.println("wrong side (got "+side.ordinal()+", need "+inputSide+")");
			return;
		}
		
		if(!itemMatchesItemFilter(stack))
			return;
		
		if(inFilter == null) {
			//System.out.println(xCoord+","+yCoord+","+zCoord+" creating filter for "+inLabel);
			inFilter = LabelParser.parseFilter(inLabel);
		}
		if(!inFilter.matches(label)) {
			//System.out.println(inLabel+" doesn't match "+label);
			return;
		}
		
		try {
			recursive = true;
			pushItemToAnyOutput(stack, op);
		} finally {
			recursive =	false;
		}
	}
	
	@Override
	public int getItemReceptorPriority() {
		return priority;
	}
	
	@Override
	public boolean connectsOnSide(int i) {
		return i == inputSide || i == outputSide;
	}

	@Override
	public int getDislocatorPriority() {
		return -priority;
	}

	@Override
	public boolean dislocate(ItemStack matching, String label, String filter, int amount, Operation op) throws Operation.DontCauseLagException {
		op.countMethodCall();
		
		IInventory inv = getOutputInventory();
		if(inv == null)
			return false;
		IRestrictedInventory invR = (inv instanceof IRestrictedInventory ? (IRestrictedInventory)inv : null);
		
		if(inFilter == null)
			inFilter = LabelParser.parseFilter(inLabel);
		if(!inFilter.matches(filter))
			return false;
		
		int size = inv.getSizeInventory();
		for(int k = 0; k < size; k++) {
			ItemStack invStack = inv.getStackInSlot(k);
			if(invStack != null && (invR == null || invR.canExtract(k)) && (matching == null || ImmibisCore.areItemsEqual(invStack, matching))) {
				//System.out.println("matched input slot "+k);
				int oldSize = invStack.stackSize;
				
				int splitSize = invStack.stackSize;
				if(amount != 0) {
					if(splitSize < amount)
						continue;
					else
						splitSize = amount;
				}
				
				ItemStack splitStack = invStack.splitStack(splitSize);
				
				pushItemToTubesInDirection(splitStack, inputSide, label, op);
				invStack.stackSize += splitStack.stackSize;
				inv.setInventorySlotContents(k, invStack.stackSize <= 0 ? null : invStack);
				
				//System.out.println("sent "+(oldSize-invStack.stackSize)+" items of "+invStack+" to "+inputSide+" with "+label);
				
				return invStack.stackSize < oldSize;
			}
		}
		return false;
	}
	
	@Override
	public void onPlaced(EntityLiving player, int look) {
		inputSide = look ^ 1;
		outputSide = look;
	}
}
