package mods.immibis.infinitubes;


import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import mods.immibis.core.net.AbstractContainerSyncPacket;

public class TransporterGuiUpdatePacket extends AbstractContainerSyncPacket {
	public String inLabel, outLabel;

	@Override
	public byte getID() {
		return InfiniTubes.PKT_TRANSPORTER_GUI;
	}

	@Override
	public String getChannel() {
		return InfiniTubes.CHANNEL;
	}

	@Override
	public void read(DataInputStream in) throws IOException {
		inLabel = in.readUTF();
		outLabel = in.readUTF();
	}

	@Override
	public void write(DataOutputStream out) throws IOException {
		out.writeUTF(inLabel);
		out.writeUTF(outLabel);
	}
	
	
}
