package mods.immibis.infinitubes;

import java.util.List;

import net.minecraft.entity.player.EntityPlayer;
import mods.immibis.core.TileBasicInventory;

public class MachineTileBase extends TileBasicInventory {
	public MachineTileBase(int invSize, String invname) {
		super(invSize, invname);
	}

	public boolean connectsOnSide(int i) {
		return false;
	}
	
	public void explodeFromLag() {
		if(worldObj.isRemote)
			return;
		
		for(EntityPlayer pl : (List<EntityPlayer>)worldObj.playerEntities) {
			if(pl.getDistanceSq(xCoord+0.5, yCoord+0.5, zCoord+0.5) <= 64)
				pl.sendChatToPlayer("Time limit exceeded when teleposing or dislocating. Don't do that or you'll cause lag (and more explosions).");
		}
		
		worldObj.newExplosion(null, xCoord+0.5, yCoord+0.5, zCoord+0.5, 0.0f, false, false);
		worldObj.setBlockToAir(xCoord, yCoord, zCoord);
	}
}
