package mods.immibis.infinitubes;


import java.util.ArrayList;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

import mods.immibis.core.BlockCombined;
import mods.immibis.core.api.util.Dir;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MachineBlock extends BlockCombined {
	public MachineBlock(int id) {
		super(id, Material.iron, "immibis/infinitubes", new String[] {"teleposer", "dislocator"});
	}
	
	public Icon[] iTeleposerIn = new Icon[6];
	public Icon[] iTeleposerOut = new Icon[6];
	public Icon[] iTeleposerSide = new Icon[6];
	public Icon[] iDislocatorIn = new Icon[6];
	public Icon[] iDislocatorSide = new Icon[6];
	public Icon iPowerTop, iPowerBottom, iPowerSide;
	
	@Override
	@SideOnly(Side.CLIENT)
	public void registerIcons(IconRegister reg) {
		for(int k = 0; k < 6; k++) {
			iTeleposerIn[k] = reg.registerIcon("immibis/infinitubes:tin"+k);
			iTeleposerOut[k] = reg.registerIcon("immibis/infinitubes:tout"+k);
			iTeleposerSide[k] = reg.registerIcon("immibis/infinitubes:tside"+k);
			iDislocatorIn[k] = reg.registerIcon("immibis/infinitubes:din"+k);
			iDislocatorSide[k] = reg.registerIcon("immibis/infinitubes:dside"+k);
		}
		iPowerBottom = reg.registerIcon("immibis/infinitubes:pbottom");
		iPowerTop = reg.registerIcon("immibis/infinitubes:ptop");
		iPowerSide = reg.registerIcon("immibis/infinitubes:pside");
	}

	@Override
	public Icon getIcon(int side, int data) {
		if(data == 0) {
			return iTeleposerSide[side];
		} else if(data == 1) {
			// power junction
			if(side == Dir.PY)
				return iPowerTop;
			else if(side == Dir.NY)
				return iPowerBottom;
			else
				return iPowerSide;
		} else if(data == 2) {
			return iDislocatorSide[side];
		}
		return null;
	}
	
	@Override
	public Icon getBlockTexture(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
		TileEntity te = par1iBlockAccess.getBlockTileEntity(par2, par3, par4);
		if(te instanceof TransporterTile) {
			TransporterTile tt = (TransporterTile)te;
			if(par5 == tt.inputSide)
				return iTeleposerIn[par5];
			else if(par5 == tt.outputSide)
				return iTeleposerOut[par5];
			else
				return iTeleposerSide[par5];
		}
		if(te instanceof PowerJunctionTile) {
			if(par5 == Dir.PY)
				return iPowerTop;
			else if(par5 == Dir.NY)
				return iPowerBottom;
			else
				return iPowerSide;
		}
		if(te instanceof DislocatorTile) {
			if(par5 == ((DislocatorTile)te).facing)
				return iDislocatorIn[par5];
			else
				return iDislocatorSide[par5];
		}
		return null;
	}

	@Override
	public TileEntity getBlockEntity(int data) {
		try {
			switch(data) {
			case 0: return new TransporterTile();
			case 1: return new PowerJunctionTile();
			case 2: return new DislocatorTile();
			default: return null;
			}
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}

	@SuppressWarnings({"rawtypes","unchecked"})
	@Override
	public void addCreativeItems(ArrayList arraylist) {
		arraylist.add(new ItemStack(this, 1, 0));
		arraylist.add(new ItemStack(this, 1, 1));
		arraylist.add(new ItemStack(this, 1, 2));
	}
	
	@Override
	public void onBlockAdded(World world, int x, int y, int z) {
		super.onBlockAdded(world, x, y, z);
		WorldTubeMap.getForWorld(world).addMachine(x, y, z);
	}
	
	@Override
	public void breakBlock(World world, int x, int y, int z, int blockID, int meta) {
		WorldTubeMap.getForWorld(world).removeMachine(x, y, z);
		super.breakBlock(world, x, y, z, blockID, meta);
	}
	
	@Override
	public boolean isBlockNormalCube(World world, int x, int y, int z) {
		return true;
	}
}
