package mods.immibis.infinitubes;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class InventoryHelper {
	@SuppressWarnings("deprecation")
	public static IInventory getInventory(World world, int x, int y, int z, int side) {
		TileEntity te = world.getBlockTileEntity(x, y, z);
		if(te instanceof ISidedInventory) {
			ISidedInventory isi = (ISidedInventory)te;
			int[] slots = isi.getAccessibleSlotsFromSide(side);
			if(slots.length == 0)
				return null;
			return new VanillaSidedAdapter(isi, slots, side);
		}
		if(te instanceof net.minecraftforge.common.ISidedInventory) {
			net.minecraftforge.common.ISidedInventory isi = (net.minecraftforge.common.ISidedInventory)te;
			int start = isi.getStartInventorySide(ForgeDirection.VALID_DIRECTIONS[side]);
			int size = isi.getSizeInventorySide(ForgeDirection.VALID_DIRECTIONS[side]);
			if(size == 0)
				return null;
			return new RangeAdapter(isi, start, size);
		}
		if(te instanceof TileEntityChest) {
			IInventory inv = (IInventory)te;
			for(int k = 2; k < 6; k++) {
				ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[k];
				te = world.getBlockTileEntity(x + fd.offsetX, y, z + fd.offsetZ);
				if(te instanceof TileEntityChest) {
					inv = new InventoryLargeChest("", inv, (IInventory)te);
				}
			}
			return inv;
		}
		if(te instanceof IInventory)
			return (IInventory)te;
		return null;
	}
	
	private static class RangeAdapter implements IInventory {
		private IInventory base;
		private int start, size;
		public RangeAdapter(IInventory base, int start, int size) {
			this.base = base;
			this.start = start;
			this.size = size;
		}
		@Override
		public int getSizeInventory() {
			return size;
		}
		@Override
		public ItemStack getStackInSlot(int var1) {
			return base.getStackInSlot(var1 + start);
		}
		@Override
		public ItemStack decrStackSize(int var1, int var2) {
			return base.decrStackSize(var1 + start, var2);
		}
		@Override
		public ItemStack getStackInSlotOnClosing(int var1) {
			return base.getStackInSlotOnClosing(var1 + start);
		}
		@Override
		public void setInventorySlotContents(int var1, ItemStack var2) {
			base.setInventorySlotContents(var1 + start, var2);
		}
		@Override
		public String getInvName() {
			return base.getInvName();
		}
		@Override
		public int getInventoryStackLimit() {
			return base.getInventoryStackLimit();
		}
		@Override
		public void onInventoryChanged() {
			base.onInventoryChanged();
		}
		@Override
		public boolean isUseableByPlayer(EntityPlayer var1) {
			return base.isUseableByPlayer(var1);
		}
		@Override
		public void openChest() {
			base.openChest();
		}
		@Override
		public void closeChest() {
			base.closeChest();
		}
		@Override
		public boolean isInvNameLocalized() {
			return base.isInvNameLocalized();
		}
		@Override
		public boolean isStackValidForSlot(int i, ItemStack itemstack) {
			return base.isStackValidForSlot(i + start, itemstack);
		}
	}
	
	private static class VanillaSidedAdapter implements IInventory, IRestrictedInventory {
		private ISidedInventory inv;
		private int side;
		private int[] slots;
		
		public VanillaSidedAdapter(ISidedInventory inv, int[] slots, int side) {
			this.inv = inv;
			this.slots = slots;
			this.side = side;
		}

		@Override
		public int getSizeInventory() {
			return slots.length;
		}

		@Override
		public ItemStack getStackInSlot(int i) {
			return inv.getStackInSlot(slots[i]);
		}

		@Override
		public ItemStack decrStackSize(int i, int j) {
			return inv.decrStackSize(slots[i], j);
		}

		@Override
		public ItemStack getStackInSlotOnClosing(int i) {
			return inv.getStackInSlotOnClosing(slots[i]);
		}

		@Override
		public void setInventorySlotContents(int i, ItemStack itemstack) {
			inv.setInventorySlotContents(slots[i], itemstack);
		}

		@Override
		public String getInvName() {
			return inv.getInvName();
		}

		@Override
		public boolean isInvNameLocalized() {
			return inv.isInvNameLocalized();
		}

		@Override
		public int getInventoryStackLimit() {
			return inv.getInventoryStackLimit();
		}

		@Override
		public void onInventoryChanged() {
			inv.onInventoryChanged();
		}

		@Override
		public boolean isUseableByPlayer(EntityPlayer entityplayer) {
			return inv.isUseableByPlayer(entityplayer);
		}

		@Override
		public void openChest() {
			inv.openChest();
		}

		@Override
		public void closeChest() {
			inv.closeChest();
		}

		@Override
		public boolean isStackValidForSlot(int i, ItemStack itemstack) {
			return inv.isStackValidForSlot(slots[i], itemstack);
		}

		@Override
		public boolean canExtract(int slot) {
			slot = slots[slot];
			
			ItemStack stack = inv.getStackInSlot(slot);
			return inv.canExtractItem(slot, stack, side);
		}

		@Override
		public boolean canInsert(int slot, ItemStack item) {
			return inv.isStackValidForSlot(slots[slot], item) && inv.canInsertItem(slots[slot], item, side);
		}
	}
		

	public static IInventory getInventoryOnSide(World worldObj, int xCoord, int yCoord, int zCoord, int direction) {
		ForgeDirection fd = ForgeDirection.VALID_DIRECTIONS[direction];
		xCoord += fd.offsetX;
		yCoord += fd.offsetY;
		zCoord += fd.offsetZ;
		return getInventory(worldObj, xCoord, yCoord, zCoord, direction ^ 1);
	}
}
