package mods.immibis.infinitubes;

import mods.immibis.core.api.util.Dir;
import mods.immibis.microblocks.api.MicroblockAPIUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import cpw.mods.fml.common.registry.LanguageRegistry;

public class InfiniTubeItem extends ItemBlock {

	public InfiniTubeItem(int id_minus_256) {
		super(id_minus_256);
		
		LanguageRegistry.addName(new ItemStack(this, 1, 0), "Transport conduit");
	}
	
	@Override
	public String getUnlocalizedName(ItemStack par1ItemStack) {
		return "immibis.infinitube." + par1ItemStack.getItemDamage();
	}
	
	@Override
	public boolean onItemUse(ItemStack stack, EntityPlayer ply, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
		int oldBlockID = w.getBlockId(x, y, z);
		Block microblockContainerBlock = MicroblockAPIUtils.getMicroblockContainerBlock();
		if(
			(microblockContainerBlock == null || oldBlockID != microblockContainerBlock.blockID)
			&& oldBlockID != 0 && !Block.blocksList[oldBlockID].isBlockReplaceable(w, x, y, z)) {
			switch(side) {
			case Dir.NX: x--; break;
			case Dir.PX: x++; break;
			case Dir.NY: y--; break;
			case Dir.PY: y++; break;
			case Dir.NZ: z--; break;
			case Dir.PZ: z++; break;
			}
			if(!w.blockExists(x, y, z))
				return false;
			
			oldBlockID = w.getBlockId(x, y, z);
			
			if(oldBlockID != 0 && !Block.blocksList[oldBlockID].isBlockReplaceable(w, x, y, z))
				return false;
		}
		
		if(microblockContainerBlock != null && oldBlockID == microblockContainerBlock.blockID) {
			if(!w.isRemote)
				if(MicroblockAPIUtils.mergeIntoMicroblockContainer(stack, ply, w, x, y, z, side, itemID, 0))
					stack.stackSize--;
			return true;
		}
		
		w.setBlock(x, y, z, itemID, 0, 3);
		stack.stackSize--;
		return true;
	}
	
	@Override
	public boolean canPlaceItemBlockOnSide(World par1World, int par2, int par3, int par4, int par5, EntityPlayer par6EntityPlayer, ItemStack par7ItemStack) {
		return true;
	}

}
