package mods.immibis.ccperiphs;

import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ItemComponent extends Item {

	public static final int META_CPU_CORE = 0;
	public static final int META_CPU_CORE_8 = 1;
	public static final int META_CPU_CORE_64 = 2;
	
	private Icon[] icons = new Icon[3];
	
	public ItemComponent(int i) {
		super(i);
		
		setMaxDamage(0);
		setHasSubtypes(true);
		setCreativeTab(CreativeTabs.tabMisc);
		
		LanguageRegistry.addName(new ItemStack(this, 1, META_CPU_CORE), "Microprocessor core");
		LanguageRegistry.addName(new ItemStack(this, 1, META_CPU_CORE_8), "Microprocessor core x 8");
		LanguageRegistry.addName(new ItemStack(this, 1, META_CPU_CORE_64), "Microprocessor core x 64");
	}
	
	@Override
	public String getUnlocalizedName(ItemStack par1ItemStack) {
		return "immibis.ccperiphs.component." + par1ItemStack.getItemDamage();
	}
	
	@Override
	@SideOnly(Side.CLIENT)
	public Icon getIconFromDamage(int par1) {
		if(par1 < 0 || par1 >= icons.length)
			return null;
		else
			return icons[par1];
	}
	
	@Override
	@SideOnly(Side.CLIENT)
	public void func_94581_a(IconRegister reg) {
		icons[META_CPU_CORE] = reg.func_94245_a("immibis/ccperiphs:mcore1");
		icons[META_CPU_CORE_8] = reg.func_94245_a("immibis/ccperiphs:mcore8");
		icons[META_CPU_CORE_64] = reg.func_94245_a("immibis/ccperiphs:mcore64");
	}
}
