package mods.immibis.microblocks.coremod;

import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import mods.immibis.core.api.APILocator;

import mods.immibis.core.api.multipart.IMultipartSystem;

public abstract class MSTHooks {
	private MSTHooks() {}
	
	private static final IMultipartSystem ims = APILocator.getMultipartSystem();
	
	public static int overrideRenderType(int base) {
		return ims.overrideRenderType(base);
	}
	
	public static void onBlockClicked(World w, int x, int y, int z, EntityPlayer ply) {
		ims.onBlockClicked(w, x, y, z, ply);
	}

	public static float getPlayerRelativeBlockHardness(EntityPlayer ply, World w, int x, int y, int z) {
		return ims.getPlayerRelativeBlockHardness(ply, w, x, y, z);
	}

	public static void renderBlock(RenderBlocks rb, Block block, int xCoord, int yCoord, int zCoord) {
		ims.renderBlockInWorldUsingOverriddenRenderType(rb, block, xCoord, yCoord, zCoord);
	}

	public static List<ItemStack> getBlockDropped() {
		return ims.getBlockDropped();
	}

	public static void onRemoveBlockByPlayer(World w, EntityPlayer pl, int x, int y, int z) {
		ims.onRemoveBlockByPlayer(w, pl, x, y, z);
	}
}
