package immibis.core.porting;

/* $if mc == 1.2.5 && jserver$ */
/* $if server2$ */

import immibis.core.api.porting.IClientPacketHandler;
import immibis.core.api.porting.IServerPacketHandler;
import immibis.core.api.porting.PortableBaseMod;
import immibis.core.api.porting.PortableGuiHandler;
import immibis.core.api.porting.SidedProxy;
import immibis.core.aspects.ServerOnly;

import java.io.File;

import net.minecraft.server.MinecraftServer;
import net.minecraft.src.*;
import net.minecraft.src.forge.*;
import net.minecraftforge.common.*;

@ServerOnly
public class ServerProxy125 extends SidedProxy {

	@Override
	public File getMinecraftDir() {
		return new File(".");
	}

	@Override
	public void addLocalization(String key, String value) {
	}

	@Override
	public void sendChat(String msg, EntityPlayer player) {
		if(player instanceof EntityPlayerMP) {
			((EntityPlayerMP)player).playerNetServerHandler.netManager.addToSendQueue(new Packet3Chat(msg));
		}
	}

	@Override
	public double getPlayerReach(EntityPlayer ply) {
		throw new UnsupportedOperationException();
	}

	@Override
	public EntityPlayer getThePlayer() {
		throw new UnsupportedOperationException();
	}

	@Override
	public int getUniqueBlockModelID(String renderClass, boolean b) {
		return 0;
	}

	@Override
	public boolean isOp(String player) {
		return ModLoader.getMinecraftServerInstance().configManager.isOp(player);
	}

	@Override
	public void preloadTexture(String texfile) {
	}

	@Override
	public void registerTileEntity(Class<? extends TileEntity> clazz, String id, String rclass) {
		ModLoader.registerTileEntity(clazz, id);
	}

	@Override
	public boolean isWorldCurrent(World w) {
		return DimensionManager.getWorld(w.worldProvider.worldType) == w;
	}

	@Override
	public void registerItemRenderer(int itemID, String renderClassName) {
	}

	@Override
	public void registerServerPacketHandler(final String channel, final IServerPacketHandler handler) {
		MinecraftForge.registerConnectionHandler(new IConnectionHandler() {
			
			public void onConnect(NetworkManager network) {
				MessageManager.getInstance().registerChannel(network, new IPacketHandler() {
					@Override
					public void onPacketData(NetworkManager network, String channel_, byte[] data) {
						if(!(network.getNetHandler() instanceof NetServerHandler))
							return;
						EntityPlayer source = ((NetServerHandler)network.getNetHandler()).getPlayerEntity();
						if(source == null)
							return;
						handler.onPacketData(channel_, data, source);
					}
				}, channel);
			}

		    public void onLogin(NetworkManager network, Packet1Login login) {
		    	
		    }

		    public void onDisconnect(NetworkManager network, String message, Object[] args) {
		    	
		    }
		});
	}

	@Override
	public void registerClientPacketHandler(String channel, IClientPacketHandler handler) {
		
	}

	@Override
	public void sendPacket(Packet250CustomPayload wrap, EntityPlayer player) {
		if(player instanceof EntityPlayerMP)
			((EntityPlayerMP)player).playerNetServerHandler.netManager.addToSendQueue(wrap);
	}

	@Override
	public void setGuiHandler(PortableBaseMod mod, PortableGuiHandler handler) {
		MinecraftForge.setGuiHandler(mod, handler);
	}

	@Override
	public boolean isClient(Entity e) {
		return false;
	}

	@Override
	public boolean isServer(Entity e) {
		return true;
	}

	@Override
	public boolean isDedicatedServer() {
		return true;
	}

	@Override
	public Vec3D createVector(IBlockAccess world, double x, double y, double z) {
		return Vec3D.createVector(x, y, z);
	}
}

/* $endif$ */
/* $endif$ */