package immibis.core.covers;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import immibis.core.mod_ImmibisCore;
import immibis.core.net.IPacket;

public class PacketMicroblockPlace implements IPacket {
	
	public int x, y, z, posid;

	public PacketMicroblockPlace(int x, int y, int z, int posid) {
		this.x = x;
		this.y = y;
		this.z = z;
		this.posid = posid;
	}
	
	public PacketMicroblockPlace() {
		this(0, 0, 0, 0);
	}

	@Override
	public byte getID() {
		return mod_ImmibisCore.PACKET_TYPE_C2S_MICROBLOCK_PLACE;
	}

	@Override
	public void read(DataInputStream in) throws IOException {
		x = in.readInt();
		y = in.readInt();
		z = in.readInt();
		posid = in.readInt();
	}

	@Override
	public void write(DataOutputStream out) throws IOException {
		out.writeInt(x);
		out.writeInt(y);
		out.writeInt(z);
		out.writeInt(posid);
	}

	@Override
	public void onReceived(EntityPlayer source) {
		if(source != null) {
			if(posid < 0 || posid >= EnumPosition.values().length) {
				return;
			}
			EnumPosition pos = EnumPosition.values()[posid];
			ItemStack h = source.getCurrentEquippedItem();
			if(h == null || !(Item.itemsList[h.itemID] instanceof ItemMultipart)) {
				return;
			}
			ItemMultipart i = (ItemMultipart)Item.itemsList[h.itemID];
			i.placeInBlock(source.worldObj, x, y, z, pos, h);
			source.worldObj.markBlockNeedsUpdate(x, y, z);
			if(h.stackSize == 0)
				source.destroyCurrentEquippedItem();
		}
	}

}
