package immibis.core.covers;

import immibis.core.mod_ImmibisCore;
import net.minecraft.src.*;
import immibis.core.*;
import immibis.core.api.Dir;
import immibis.core.api.porting.SidedProxy;
import immibis.core.aspects.ClientOnly;
import immibis.core.net.OneTwoFiveNetworking;

public class ItemMultipart extends ItemBlock {
	
	private BlockMultipart block;

	public ItemMultipart(int id) {
		super(id);
		block = (BlockMultipart)block.blocksList[shiftedIndex];
	}

	@ClientOnly
	public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int x, int y, int z, int dir)
    {
		if(world.isRemote) {
			/* $if jclient && mc < 1.3$ */
	        MovingObjectPosition ray = entityplayer.rayTrace(SidedProxy.instance.getPlayerReach(entityplayer), 0);
	        if(ray == null)
	        	return false;
	
	        x = ray.blockX;
	        y = ray.blockY;
	        z = ray.blockZ;
	        dir = ray.sideHit;
	        TileEntity rayTE = (world.getBlockTileEntity(ray.blockX, ray.blockY, ray.blockZ));
	        Part rayPart = null;
	        if(rayTE instanceof ICoverableTile) 
	        {
	        	 if(ray.subHit >= 0)
	        		 rayPart = ((ICoverableTile)rayTE).getCoverImpl().parts.get(ray.subHit);
	        	 else if(ray.subHit == -2)
	        		 rayPart = ((TileCoverableBase)rayTE).getFakeCentrePart();
	        }
	        
	        int oldblock = world.getBlockId(x, y, z);
	        if (oldblock == Block.snow.blockID)
	            dir = 0;
	        else if (oldblock != Block.vine.blockID)
	        {
	        	int dx=0, dy=0, dz=0;
	        	switch(dir)
	        	{
	        	case Dir.NX: if(rayPart == null || rayPart.pos.x.touchesNegative()) dx=-1; break;
	        	case Dir.PX: if(rayPart == null || rayPart.pos.x.touchesPositive()) dx=1; break;
	        	case Dir.NY: if(rayPart == null || rayPart.pos.y.touchesNegative()) dy=-1; break;
	        	case Dir.PY: if(rayPart == null || rayPart.pos.y.touchesPositive()) dy=1; break;
	        	case Dir.NZ: if(rayPart == null || rayPart.pos.z.touchesNegative()) dz=-1; break;
	        	case Dir.PZ: if(rayPart == null || rayPart.pos.z.touchesPositive()) dz=1; break;
	        	}
	        	if(dx != 0 || dy != 0 || dz != 0)
	        	{
	        		x += dx;
	        		y += dy;
	        		z += dz;
	        		rayPart = null;
	        	}
	        }
	        if (itemstack.stackSize == 0)
	            return false;
	        if (!entityplayer.canPlayerEdit(x, y, z))
	            return false;
	        
	        PartType type = CoverSystemProxy.parts.get(itemstack.getItemDamage());
	     	EnumPosition pos;
	    	if(type.clazz == EnumPartClass.Panel || type.clazz == EnumPartClass.HollowPanel)
	    	{
	    		pos = MultipartHighlightHandler.getPanelPlacement(entityplayer, ray, rayPart == null ? null : rayPart.pos);
	    	}
	    	else if(type.clazz == EnumPartClass.Corner)
	    	{
	    		pos = MultipartHighlightHandler.getCornerPlacement(entityplayer, ray, rayPart == null ? null : rayPart.pos);
	    	}
	    	else if(type.clazz == EnumPartClass.Strip)
	    	{
	    		pos = MultipartHighlightHandler.getStripPlacement(entityplayer, ray, rayPart == null ? null : rayPart.pos);
	    	}
	    	else
	    		return false;
	    	
	    	if(world.isRemote)
	    	{
	    		world.playSoundEffect((float)x + 0.5F, (float)y + 0.5F, (float)z + 0.5F, block.stepSound.getStepSound(), (block.stepSound.getVolume() + 1.0F) / 2.0F, block.stepSound.getPitch() * 0.8F);
	    		OneTwoFiveNetworking.send(mod_ImmibisCore.CHANNEL, new PacketMicroblockPlace(x, y, z, pos.ordinal()), null);
	    	}
	    	else
	    	{
	    		if(!placeInBlock(world, x, y, z, pos, itemstack))
	    			return false;
	    		if(false) {
		    		TileEntity newTE = world.getBlockTileEntity(x, y, z);
		            if(newTE == null || !(newTE instanceof ICoverableTile))
		            {
		            	if(world.getBlockId(x, y, z) != 0)
		            		return false;
		            	/* $if mc < 1.3$
		            	if(!world.canBlockBePlacedAt(block.blockID, x, y, z, true, dir))
		            	$else$ */
		            	if(!block.canPlaceBlockOnSide(world, x, y, z, dir))
		            	/* $endif$ */
		            		return false;
		            	
		            	world.setBlock(x, y, z, block.blockID);
		            	newTE = new TileMultipart();
		            	world.setBlockTileEntity(x, y, z, newTE);
		            }
		            
		            CoverImpl cover = ((ICoverableTile)newTE).getCoverImpl();
		            
		            if(!cover.addPart(new Part(type, pos)))
		    			return false;
		            
		            itemstack.stackSize--;
		    		world.notifyBlocksOfNeighborChange(x, y, z, block.blockID);
		    		world.markBlockNeedsUpdate(x, y, z);
	    		}
	    	}
	    	/* $endif$ */
	        return true;
		} else {
			// server
			return false;
		}
    }
	
	public boolean placeInBlock(World world, int x, int y, int z, EnumPosition pos, ItemStack itemstack)
	{
		/* $if mc < 1.3$
		int d = itemstack.getItemDamage();
        if(d < 0 || d >= CoverSystemProxy.parts.size()) {
        	//System.out.println("Wrong d: "+d);
        	return false;
        }
        
        TileEntity newTE = world.getBlockTileEntity(x, y, z);
        if(newTE == null || !(newTE instanceof ICoverableTile))
        {
        	if(world.getBlockId(x, y, z) != 0) {
        		//System.out.println("Something in the way");
        		return false;
        	}
        	$if mc < 1.3$
        	if(!world.canBlockBePlacedAt(block.blockID, x, y, z, true, 0)) {
        	$else$
        	if(!block.canPlaceBlockOnSide(world, x, y, z, 0)) {
        		$endif$
				//System.out.println("Not able to place block");
        		return false;
        	}
        	
        	world.setBlock(x, y, z, block.blockID);
        	newTE = new TileMultipart();
        	world.setBlockTileEntity(x, y, z, newTE);
        	//System.out.println("Created TileMultipart at "+x+","+y+","+z);
        }
        
        PartType type = CoverSystemProxy.parts.get(d);
        // should not be null
        
        CoverImpl cover = ((ICoverableTile)newTE).getCoverImpl();
        // should not be null
        
        if(!cover.addPart(new Part(type, pos))) {
        	//System.out.println("addPart failed");
			return false;
        }
        
        itemstack.stackSize--;
		world.notifyBlocksOfNeighborChange(x, y, z, block.blockID);
		world.markBlockNeedsUpdate(x, y, z);
		//System.out.println("Added part");
		$endif$ */
		return true;
	}
	
	@Override
	public String getItemNameIS(ItemStack is) {
		return "immibis.core.multipart." + is.getItemDamage();
	}
	
	@Override
	public boolean getHasSubtypes() {
		return true;
	}

}
