package immibis.core.covers;

import immibis.core.*;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.WeakHashMap;

import net.minecraft.src.*;

public class BlockMultipart extends BlockContainer implements ICoverableBlock {
	
	private final int model;
	
	static AxisAlignedBB selectedBoundingBox = AxisAlignedBB.getBoundingBox(0, 0, 0, 1, 1, 1);
	static int[] texindices = new int[] {0, 0, 0, 0, 0, 0};
	
	@Override
	public void getCollidingBoundingBoxes(World world, int x, int y, int z, AxisAlignedBB mask, ArrayList list) {
		// TODO figure out why this is broken on the server side
		/*try {
			((ICoverableTile)world.getBlockTileEntity(x, y, z)).getCoverImpl().getCollidingBoundingBoxes(world, x, y, z, mask, list);
		} catch(ClassCastException e) {
			world.setBlockWithNotify(x, y, z, 0);
		}*/
	}
	
	public float blockStrengthMultipart(EntityPlayer ply, int meta) {
		return super.blockStrength(ply, meta);
	}
	
	public void harvestBlockMultipart(World world, EntityPlayer ply, int x, int y, int z, int blockMetadata) {
		super.harvestBlock(world, ply, x, y, z, blockMetadata);
	}
	
	private static float hardness;
	//private static boolean forceHarvestState, forcedHarvestState;
	
	public boolean canHarvestBlockMultipart(EntityPlayer ply, int meta) {
		return true;
		//return super.canHarvestBlock(ply, meta);
	}
	
	@Override
	public final boolean canHarvestBlock(EntityPlayer ply, int meta) {
		//if(forceHarvestState)
			//return forcedHarvestState;
		return canHarvestBlockMultipart(ply, meta);
	}
	
	@Override
	public final float getHardness(int meta) {
		return hardness;
	}
	
	static WeakHashMap<EntityPlayer, Integer> punching_subhit = new WeakHashMap<EntityPlayer, Integer>();
	
	public static void setPunchingSubhit(EntityPlayer ply, int subhit)
	{
		punching_subhit.put(ply, subhit);
	}
	
	static int getPunchingSubhit(EntityPlayer ply) {
		Integer o = punching_subhit.get(ply);
		if(o == null)
			return -1000;
		return o;
	}
	
	@Override
	public boolean removeBlockByPlayer(World w, EntityPlayer ply, int i, int j, int k) {
		if(ply.capabilities.isCreativeMode)
			harvestBlock(w, ply, i, j, k, w.getBlockMetadata(i, j, k));
		return true;
	}
	
	@Override
	public final float blockStrength(World world, EntityPlayer ply, int x, int y, int z) {
		//if(!(ply instanceof EntityPlayerMP))
			//return 0.0f;
		int subHit = getPunchingSubhit(ply);
		{
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te == null || !(te instanceof ICoverableTile))
				return 0.01f;
			else
			{
				CoverImpl cover = ((ICoverableTile)te).getCoverImpl();
				
				int meta = world.getBlockMetadata(x, y, z);
				
				if(subHit == -2)
					return blockStrengthMultipart(ply, meta);
				if(subHit < 0 || subHit >= cover.parts.size())
					return 0.01f;
				Part p = cover.parts.get(subHit);
				if(p == null)
					return 0.01f;
				else
				{
					hardness = p.type.hardness;
					if(hardness < 0)
						return 0;
					if(!p.type.canHarvestCover(ply))
						return 0.01F / hardness;
					return ply.getCurrentPlayerStrVsBlock(p.type.modelBlock, p.type.modelMeta) / hardness / 30F;
				}
			}
		}
	}

	@Override
	public final void harvestBlock(World world, EntityPlayer ply, int x, int y, int z, int meta) {
		int subHit = getPunchingSubhit(ply);
		try {
			((ICoverableTile)world.getBlockTileEntity(x, y, z)).getCoverImpl().harvestBlock(world, ply, x, y, z, subHit);
		} catch(ClassCastException e) {
			world.setBlockWithNotify(x, y, z, 0);
		}
	}
	
	@Override
	public void dropBlockAsItem_do(World w, int x, int y, int z, ItemStack is) {
		super.dropBlockAsItem_do(w, x, y, z, is);
	}
	
	void setAABB(AxisAlignedBB aabb)
	{
		minX = aabb.minX;
		minY = aabb.minY;
		minZ = aabb.minZ;
		maxX = aabb.maxX;
		maxY = aabb.maxY;
		maxZ = aabb.maxZ;
	}

	protected BlockMultipart(int id, Material mat, int model) {
		super(id, mat);
		this.model = model;
	}
	
	MovingObjectPosition defaultCollisionRayTrace(World world, int x, int y, int z, Vec3D src, Vec3D dst) {
		return super.collisionRayTrace(world, x, y, z, src, dst);
	}
	
	@Override
	public MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3D src, Vec3D dst) {
		try {
			return ((ICoverableTile)world.getBlockTileEntity(x, y, z)).getCoverImpl().collisionRayTrace(world, x, y, z, src, dst);
		} catch(ClassCastException e) {
			world.setBlockWithNotify(x, y, z, 0);
			return super.collisionRayTrace(world, x, y, z, src, dst);
		}
	}
	
	@Override
	public final boolean isOpaqueCube() {
		return false;
	}
	
	@Override
	public final boolean renderAsNormalBlock() {
		return false;
	}
	
	@Override
	public int getRenderType() {
		return model;
	}

	@Override
	public TileEntity getBlockEntity() {
		return new TileMultipart();
	}

}
