package immibis.core.porting;

import forge.DimensionManager;
import forge.IConnectionHandler;
import forge.IPacketHandler;
import forge.MessageManager;
import forge.MinecraftForge;
import immibis.core.api.porting.IClientPacketHandler;
import immibis.core.api.porting.IServerPacketHandler;
import immibis.core.api.porting.PortableBaseMod;
import immibis.core.api.porting.PortableGuiHandler;
import immibis.core.api.porting.SidedProxy;
import immibis.core.aspects.ServerOnly;
import java.io.File;

import org.bukkit.Bukkit;

import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.ModLoader;
import net.minecraft.server.NetServerHandler;
import net.minecraft.server.NetworkManager;
import net.minecraft.server.Packet1Login;
import net.minecraft.server.Packet250CustomPayload;
import net.minecraft.server.Packet3Chat;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

@ServerOnly
public class ServerProxy125 extends SidedProxy
{
    public File getMinecraftDir()
    {
        return new File(".");
    }

    public void addLocalization(String var1, String var2) {}

    public void sendChat(String var1, EntityHuman var2)
    {
        if (var2 instanceof EntityPlayer)
        {
            ((EntityPlayer)var2).netServerHandler.networkManager.queue(new Packet3Chat(var1));
        }
    }

    public double getPlayerReach(EntityHuman var1)
    {
        throw new UnsupportedOperationException();
    }

    public EntityHuman getThePlayer()
    {
        throw new UnsupportedOperationException();
    }

    public int getUniqueBlockModelID(String var1, boolean var2)
    {
        return 0;
    }

    public boolean isOp(String var1)
    {
        return ModLoader.getMinecraftServerInstance().serverConfigurationManager.isOp(var1);
    }

    public void preloadTexture(String var1) {}

    public void registerTileEntity(Class var1, String var2, String var3)
    {
        ModLoader.registerTileEntity(var1, var2);
    }

    public boolean isWorldCurrent(World var1)
    {
        return Bukkit.getWorld(var1.getUUID()) == var1.getWorld();
    }

    public void registerItemRenderer(int var1, String var2) {}

    public void registerServerPacketHandler(final String var1, final IServerPacketHandler var2)
    {
        MinecraftForge.registerConnectionHandler(new IConnectionHandler()
        {
            public void onConnect(NetworkManager var1x)
            {
                MessageManager.getInstance().registerChannel(var1x, new IPacketHandler()
                {
                    public void onPacketData(NetworkManager var1, String var2x, byte[] var3)
                    {
                        if (var1.getNetHandler() instanceof NetServerHandler)
                        {
                            EntityPlayer var4 = ((NetServerHandler)var1.getNetHandler()).getPlayerEntity();

                            if (var4 != null)
                            {
                                var2.onPacketData(var2x, var3, var4);
                            }
                        }
                    }
                }, var1);
            }
            public void onLogin(NetworkManager var1x, Packet1Login var2x) {}
            public void onDisconnect(NetworkManager var1x, String var2x, Object[] var3) {}
        });
    }

    public void registerClientPacketHandler(String var1, IClientPacketHandler var2) {}

    public void sendPacket(Packet250CustomPayload var1, EntityHuman var2)
    {
        if (var2 instanceof EntityPlayer)
        {
            ((EntityPlayer)var2).netServerHandler.networkManager.queue(var1);
        }
    }

    public void setGuiHandler(PortableBaseMod var1, PortableGuiHandler var2)
    {
        MinecraftForge.setGuiHandler(var1, var2);
    }

    public boolean isClient(Entity var1)
    {
        return false;
    }

    public boolean isServer(Entity var1)
    {
        return true;
    }

    public boolean isDedicatedServer()
    {
        return true;
    }

    public Vec3D createVector(IBlockAccess var1, double var2, double var4, double var6)
    {
        return Vec3D.create(var2, var4, var6);
    }
}
