package immibis.core.porting;

/* $if mc == 1.3.2 && jclient$

import immibis.core.mod_ImmibisCore;
import immibis.core.api.porting.IClientPacketHandler;
import immibis.core.api.porting.IServerPacketHandler;
import immibis.core.api.porting.PortableBaseMod;
import immibis.core.api.porting.PortableBlockRenderer;
import immibis.core.api.porting.PortableGuiHandler;
import immibis.core.aspects.ClientOnly;

import java.io.File;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;

import net.minecraft.client.Minecraft;
import net.minecraft.server.Block;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.ModLoader;
import net.minecraft.server.NetworkManager;
import net.minecraft.server.Packet250CustomPayload;
import net.minecraft.server.RenderBlocks;
import net.minecraft.server.TileEntity;
import net.minecraft.server.TileEntitySpecialRenderer;
import net.minecraft.server.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

@ClientOnly
public class ClientProxy132 extends CommonProxy132 {

	@Override
	public File getMinecraftDir() {
		return Minecraft.getMinecraft().mcDataDir;
	}

	@Override
	public double getPlayerReach(EntityPlayer ply) {
		return Minecraft.getMinecraft().playerController.getBlockReachDistance();
	}

	@Override
	public EntityPlayer getThePlayer() {
		return Minecraft.getMinecraft().thePlayer;
	}

	@Override
	public int getUniqueBlockModelID(String renderClass, final boolean b) {
		try {
			final PortableBlockRenderer r = (PortableBlockRenderer)Class.forName(renderClass).getConstructor().newInstance();
			final int model = RenderingRegistry.getNextAvailableRenderId();
			RenderingRegistry.registerBlockHandler(model, new ISimpleBlockRenderingHandler() {
				@Override
				public boolean shouldRender3DInInventory() {
					return b;
				}
				
				@Override
				public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z,
						Block block, int modelId, RenderBlocks renderer) {
					return r.renderWorldBlock(renderer, world, x, y, z, block, modelId);
				}
				
				@Override
				public void renderInventoryBlock(Block block, int metadata, int modelID,
						RenderBlocks renderer) {
					r.renderInvBlock(renderer, block, metadata, modelID);
				}
				
				@Override
				public int getRenderId() {
					return model;
				}
			});
			return model;
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public boolean isOp(String player) {
		return player.equalsIgnoreCase(Minecraft.getMinecraft().thePlayer.username);
	}

	@Override
	public void preloadTexture(String texfile) {
		MinecraftForgeClient.preloadTexture(texfile);
	}

	@Override
	public void registerTileEntity(Class<? extends TileEntity> clazz, String id, String rclass) {
		try {
			TileEntitySpecialRenderer r = Class.forName(rclass).asSubclass(TileEntitySpecialRenderer.class).getConstructor().newInstance();
			GameRegistry.registerTileEntity(clazz, id);
			ClientRegistry.bindTileEntitySpecialRenderer(clazz, r);
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public boolean isWorldCurrent(World w) {
		return w == Minecraft.getMinecraft().theWorld || super.isWorldCurrent(w);
	}

	@Override
	public void registerItemRenderer(int itemID, String renderClassName) {
		try {
			IItemRenderer r = Class.forName(renderClassName).asSubclass(IItemRenderer.class).getConstructor().newInstance();
			MinecraftForgeClient.registerItemRenderer(itemID, r);
		} catch(Exception e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public void registerServerPacketHandler(String channel, final IServerPacketHandler handler) {
		NetworkRegistry.instance().registerChannel(new IPacketHandler() {
			@Override
			public void onPacketData(NetworkManager manager, Packet250CustomPayload packet, Player player) {
				if(player instanceof EntityPlayer)
					handler.onPacketData(packet.channel, packet.data, (EntityPlayer)player);
			}
		}, channel, Side.SERVER);
	}

	@Override
	public void registerClientPacketHandler(String channel, final IClientPacketHandler handler) {
		NetworkRegistry.instance().registerChannel(new IPacketHandler() {
			@Override
			public void onPacketData(NetworkManager manager, Packet250CustomPayload packet, Player player) {
				handler.onPacketData(packet.channel, packet.data);
			}
		}, channel, Side.CLIENT);
	}

	@Override
	public void sendPacket(Packet250CustomPayload wrap, EntityPlayer player) {
		if(player == null) {
			PacketDispatcher.sendPacketToServer(wrap);
		} else if(player instanceof Player) {
			PacketDispatcher.sendPacketToPlayer(wrap, (Player)player);
		}
	}

	@Override
	public void setGuiHandler(PortableBaseMod mod, final PortableGuiHandler handler) {
		NetworkRegistry.instance().registerGuiHandler(mod, new IGuiHandler() {
			
			@Override
			public Object getServerGuiElement(int ID, EntityPlayer player, World world,
					int x, int y, int z) {
				return handler.getServerGuiElement(ID, player, world, x, y, z);
			}
			
			@Override
			public Object getClientGuiElement(int ID, EntityPlayer player, World world,
					int x, int y, int z) {
				return handler.getClientGuiElement(ID, player, world, x, y, z);
			}
		});
	}

	@Override
	public boolean isClient(Entity e) {
		return e.worldObj.isRemote;
	}

	@Override
	public boolean isServer(Entity e) {
		return !e.worldObj.isRemote;
	}

	@Override
	public boolean isDedicatedServer() {
		return false;
	}

}

$endif$ */
