package immibis.core.net;

import immibis.core.api.porting.PortableContainer;
import java.util.Iterator;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ICrafting;
import net.minecraft.server.IInventory;

public abstract class AbstractSyncedContainer extends PortableContainer implements ISyncedContainer
{
    public AbstractSyncedContainer(EntityHuman var1, IInventory var2)
    {
        super(var1, var2);
    }

    public void sendUpdatePacket(IPacket var1)
    {
        String var2 = this.getChannel();
        Iterator var4 = this.listeners.iterator();

        while (var4.hasNext())
        {
            ICrafting var3 = (ICrafting)var4.next();

            if (var3 instanceof EntityHuman)
            {
                OneTwoFiveNetworking.send(var2, var1, (EntityHuman)var3);
            }
        }
    }

    public void sendActionPacket(IPacket var1)
    {
        this.sendActionPacket(var1, this.getChannel());
    }

    public void sendActionPacket(IPacket var1, String var2)
    {
        throw new IllegalStateException("Cannot send action packets from the server");
    }

    public abstract String getChannel();

    public void onActionPacket(IPacket var1) {}

    public void onUpdatePacket(IPacket var1) {}

    public void onButtonPressed(int var1) {}

    public void sendButtonPressed(int var1)
    {
        this.sendActionPacket(new PacketButtonPress(var1), "Immibis1.2.5-GUI");
    }

    private void onActionPacket2(IPacket var1)
    {
        if (var1 instanceof PacketButtonPress)
        {
            this.onButtonPressed(((PacketButtonPress)var1).buttonID);
        }
        else
        {
            this.onActionPacket(var1);
        }
    }

    public final void onReceivePacket(IPacket var1)
    {
        this.onActionPacket2(var1);
    }
}
