package immibis.core;

import immibis.core.api.IDAllocator;
import immibis.core.api.porting.PortableBaseMod;
import immibis.core.api.porting.SidedProxy;
import immibis.core.covers.CoverSystemProxy;
import immibis.core.covers.PacketMicroblockDigStart;
import immibis.core.covers.PacketMicroblockPlace;
import immibis.core.net.IPacket;
import immibis.core.net.IPacketMap;
import immibis.core.net.OneTwoFiveNetworking;
import immibis.core.net.PacketButtonPress;
import net.minecraft.server.ItemStack;

public class mod_ImmibisCore extends PortableBaseMod
{
    public static final int PACKET_TYPE_S2C_STRING_GUI = 0;
    public static final int PACKET_TYPE_S2C_MULTIPART_DESCRIPTION = 1;
    public static final int PACKET_TYPE_C2S_MICROBLOCK_DIG_START = 2;
    public static final int PACKET_TYPE_C2S_MICROBLOCK_PLACE = 3;
    public static final boolean FORCE_MICROBLOCKS_DISABLED = true;
    public static final String CHANNEL_GUI = "Immibis1.2.5-GUI";
    public static final String CHANNEL = "ImmibisCore";
    public static int coverModel;
    public static boolean coversEnabled;
    public static mod_ImmibisCore instance;

    public String getVersion()
    {
        return ModInfoReader.getModInfoField("/immibis/core/mod_ImmibisCore.info.txt", "version");
    }

    public void load()
    {
        if (Config.getBoolean("enableMicroblocks", false))
        {
            coverModel = SidedProxy.instance.getUniqueBlockModelID("immibis.core.CoreBlockRenderer", true);
            CoverSystemProxy.init(coverModel);
            coversEnabled = true;
        }
        else
        {
            coversEnabled = false;
        }

        BlockMultiTile.model = BlockMultiTile.normalModel = SidedProxy.instance.getUniqueBlockModelID("immibis.core.CoreBlockRenderer", true);
        OneTwoFiveNetworking.initReceiveServer(new IPacketMap()
        {
            public IPacket createPacket(byte var1)
            {
                return var1 == 0 ? new PacketButtonPress(0) : null;
            }
        }, "Immibis1.2.5-GUI");
        OneTwoFiveNetworking.initReceiveServer(new IPacketMap()
        {
            public IPacket createPacket(byte var1)
            {
                if (mod_ImmibisCore.coversEnabled)
                {
                    if (var1 == 2)
                    {
                        return new PacketMicroblockDigStart();
                    }

                    if (var1 == 3)
                    {
                        return new PacketMicroblockPlace();
                    }
                }

                return null;
            }
        }, "ImmibisCore");
    }

    public void modsLoaded()
    {
        IDAllocator.AllocateBlockIDs();

        if (coversEnabled)
        {
            CoverSystemProxy.ModsLoaded();
        }
    }

    public mod_ImmibisCore()
    {
        instance = this;
    }

    public static boolean areItemsEqual(ItemStack var0, ItemStack var1)
    {
        return var0 == null && var1 == null ? true : (var0 != null && var1 != null ? (var0.id != var1.id ? false : (var0.usesData() && var0.getData() != var1.getData() ? false : (var0.tag == null && var1.tag == null ? true : (var0.tag == null && var1.tag == null ? var0.tag.equals(var1.tag) : false)))) : false);
    }
}
