package immibis.core.covers;

import immibis.core.net.IPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;

public class PacketMicroblockPlace implements IPacket
{
    public int x;
    public int y;
    public int z;
    public int posid;

    public PacketMicroblockPlace(int var1, int var2, int var3, int var4)
    {
        this.x = var1;
        this.y = var2;
        this.z = var3;
        this.posid = var4;
    }

    public PacketMicroblockPlace()
    {
        this(0, 0, 0, 0);
    }

    public byte getID()
    {
        return (byte)3;
    }

    public void read(DataInputStream var1) throws IOException
    {
        this.x = var1.readInt();
        this.y = var1.readInt();
        this.z = var1.readInt();
        this.posid = var1.readInt();
    }

    public void write(DataOutputStream var1) throws IOException
    {
        var1.writeInt(this.x);
        var1.writeInt(this.y);
        var1.writeInt(this.z);
        var1.writeInt(this.posid);
    }

    public void onReceived(EntityHuman var1)
    {
        if (var1 != null)
        {
            if (this.posid < 0 || this.posid >= EnumPosition.values().length)
            {
                return;
            }

            EnumPosition var2 = EnumPosition.values()[this.posid];
            ItemStack var3 = var1.U();

            if (var3 == null || !(Item.byId[var3.id] instanceof ItemMultipart))
            {
                return;
            }

            ItemMultipart var4 = (ItemMultipart)Item.byId[var3.id];
            var4.placeInBlock(var1.world, this.x, this.y, this.z, var2, var3);
            var1.world.notify(this.x, this.y, this.z);

            if (var3.count == 0)
            {
                var1.V();
            }
        }
    }
}
