package immibis.core.covers;

import immibis.core.net.IPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.server.EntityHuman;

public class PacketMicroblockDigStart implements IPacket
{
    public int x;
    public int y;
    public int z;
    public int subhit;

    public PacketMicroblockDigStart(int var1, int var2, int var3, int var4)
    {
        this.x = var1;
        this.y = var2;
        this.z = var3;
        this.subhit = var4;
    }

    public PacketMicroblockDigStart()
    {
        this(0, 0, 0, 0);
    }

    public byte getID()
    {
        return (byte)2;
    }

    public void read(DataInputStream var1) throws IOException
    {
        this.x = var1.readInt();
        this.y = var1.readInt();
        this.z = var1.readInt();
        this.subhit = var1.readInt();
    }

    public void write(DataOutputStream var1) throws IOException
    {
        var1.writeInt(this.x);
        var1.writeInt(this.y);
        var1.writeInt(this.z);
        var1.writeInt(this.subhit);
    }

    public void onReceived(EntityHuman var1)
    {
        if (var1 != null)
        {
            BlockMultipart.setPunchingSubhit(var1, this.subhit);
        }
    }
}
