package immibis.core.api.porting;

import immibis.core.porting.ServerProxy125;
import java.io.File;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.Packet250CustomPayload;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public abstract class SidedProxy
{
    public static SidedProxy instance = new ServerProxy125();

    public abstract File getMinecraftDir();

    public abstract void addLocalization(String var1, String var2);

    public abstract void sendChat(String var1, EntityHuman var2);

    public abstract double getPlayerReach(EntityHuman var1);

    public abstract EntityHuman getThePlayer();

    public abstract int getUniqueBlockModelID(String var1, boolean var2);

    public abstract boolean isOp(String var1);

    public abstract void preloadTexture(String var1);

    public abstract void registerTileEntity(Class var1, String var2, String var3);

    public abstract boolean isWorldCurrent(World var1);

    public abstract void registerItemRenderer(int var1, String var2);

    public abstract void registerServerPacketHandler(String var1, IServerPacketHandler var2);

    public abstract void registerClientPacketHandler(String var1, IClientPacketHandler var2);

    public abstract void sendPacket(Packet250CustomPayload var1, EntityHuman var2);

    public abstract void setGuiHandler(PortableBaseMod var1, PortableGuiHandler var2);

    public abstract Vec3D createVector(IBlockAccess var1, double var2, double var4, double var6);

    public abstract boolean isClient(Entity var1);

    public abstract boolean isServer(Entity var1);

    public abstract boolean isDedicatedServer();
}
