package immibis.core;

import immibis.core.api.porting.SidedProxy;
import net.minecraft.server.Block;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ItemBlock;
import net.minecraft.server.ItemStack;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;

public abstract class ItemBlockMultiTile extends ItemBlock
{
    public int max_meta = 0;
    
    int itemID;

    public ItemBlockMultiTile(int var1, int var2)
    {
        super(var1);
        this.max_meta = var2;
        
        itemID = var1 + 256;

        for (int var3 = 0; var3 < var2; ++var3)
        {
            SidedProxy.instance.addLocalization(itemID + "." + var3 + ".name", this.getName(var3));
        }
    }

    public String a(ItemStack var1)
    {
        return itemID + "." + var1.getData();
    }

    public abstract TileEntity createTileEntity(int var1);

    public abstract String getName(int var1);

    /**
     * Callback for item usage. If the item does something special on right clicking, he will have one of those. Return
     * True if something happen and false if it don't. This is for ITEMS, not BLOCKS !
     */
    public boolean interactWith(ItemStack var1, EntityHuman var2, World var3, int var4, int var5, int var6, int var7)
    {
        int var8 = var3.getTypeId(var4, var5, var6);

        if (var8 == Block.SNOW.id)
        {
            var7 = 1;
        }
        else if (var8 != Block.VINE.id && var8 != Block.LONG_GRASS.id && var8 != Block.DEAD_BUSH.id)
        {
            if (var7 == 0)
            {
                --var5;
            }

            if (var7 == 1)
            {
                ++var5;
            }

            if (var7 == 2)
            {
                --var6;
            }

            if (var7 == 3)
            {
                ++var6;
            }

            if (var7 == 4)
            {
                --var4;
            }

            if (var7 == 5)
            {
                ++var4;
            }
        }

        int var9 = this.a();

        if (var1.count == 0)
        {
            return false;
        }
        else if (!var2.d(var4, var5, var6))
        {
            return false;
        }
        else if (var5 == 255 && Block.byId[var9].material.isBuildable())
        {
            return false;
        }
        else if (var3.mayPlace(var9, var4, var5, var6, false, var7))
        {
            Block var10 = Block.byId[var9];

            if (var3.setTypeIdAndData(var4, var5, var6, var9, 0))
            {
                var3.setTileEntity(var4, var5, var6, this.createTileEntity(var1.getData()));

                if (var3.getTypeId(var4, var5, var6) == var9)
                {
                    Block.byId[var9].postPlace(var3, var4, var5, var6, var7);
                    Block.byId[var9].postPlace(var3, var4, var5, var6, var2);
                }

                var3.makeSound((double)((float)var4 + 0.5F), (double)((float)var5 + 0.5F), (double)((float)var6 + 0.5F), var10.stepSound.getName(), (var10.stepSound.getVolume1() + 1.0F) / 2.0F, var10.stepSound.getVolume2() * 0.8F);
                --var1.count;
            }

            return true;
        }
        else
        {
            return false;
        }
    }
}
