package immibis.core;

import forge.Configuration;
import forge.Property;
import immibis.core.api.porting.SidedProxy;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.server.Item;
import net.minecraft.server.ModLoader;

public class Config
{
    private static File configFile;
    public static Configuration config;
    private static boolean autoAssign;
    private static HashSet forceAllowReassign;

    static
    {
        File var1 = new File(SidedProxy.instance.getMinecraftDir(), "config");
        var1.mkdir();
        File var0 = new File(var1, "immibis.cfg");
        config = new Configuration(var0);
        config.load();
        autoAssign = getBoolean("autoAssign", true);
        ((Property)config.generalProperties.get("autoAssign")).value = "false";
        config.save();
        forceAllowReassign = new HashSet();
    }

    public static boolean getBoolean(String var0, boolean var1)
    {
        boolean var2 = Boolean.valueOf(config.getOrCreateBooleanProperty(var0, "general", var1).value).booleanValue();
        config.save();
        return var2;
    }

    public static void save()
    {
        config.save();
    }

    public static int getBlockID(String var0, boolean var1)
    {
        try
        {
            return !var1 && !config.blockProperties.containsKey(var0 + ".id") ? 0 : Integer.parseInt(config.getOrCreateBlockIdProperty(var0 + ".id", 194).value);
        }
        catch (Exception var3)
        {
            ModLoader.throwException("This shouldn\'t be possible", var3);
            return 0;
        }
    }

    public static int getItemID(String var0, int var1)
    {
        Property var2 = config.getOrCreateIntProperty(var0, "item", var1);
        int var3 = Integer.valueOf(var2.value).intValue();

        if (Item.byId[var3] != null || var3 == 0)
        {
            if (!autoAssign)
            {
                throw new RuntimeException("Item " + var0 + " conflicts with " + Item.byId[var3] + " ");
            }

            var3 = -1;

            for (int var4 = Item.byId.length - 1; var4 >= 500; --var4)
            {
                if (Item.byId[var4] == null)
                {
                    var3 = var4;
                    break;
                }
            }

            if (var3 == -1)
            {
                throw new RuntimeException("You\'re out of item IDs! Oh no! Remove some mods! (And congratulations... there are OVER THIRTY THOUSAND of them!)");
            }

            var2.value = String.valueOf(var3);
            config.save();
        }

        return var3;
    }

    public static String getString(String var0, String var1, String var2, String var3)
    {
        boolean var4 = config.categories.get(var2) == null || ((Map)config.categories.get(var2)).get(var0) == null;
        Property var5 = config.getOrCreateProperty(var0, var2, var1);
        var4 |= var5.comment == null && var3 != null || !var5.comment.equals(var3);
        var5.comment = var3;

        if (var4)
        {
            config.save();
        }

        return var5.value;
    }

    public static int getInt(String var0, int var1)
    {
        return Integer.valueOf(config.getOrCreateIntProperty(var0, "general", var1).value).intValue();
    }
}
