package dan200.turtle.api;

import java.lang.reflect.Method;

public class TurtleAPI
{
    private static boolean ccTurtleSearched = false;
    private static Class ccTurtle = null;
    private static Method ccTurtle_registerTurtleUpgrade = null;

    public static void registerUpgrade(ITurtleUpgrade var0)
    {
        if (var0 != null)
        {
            findCCTurtle();

            if (ccTurtle_registerTurtleUpgrade != null)
            {
                try
                {
                    ccTurtle_registerTurtleUpgrade.invoke((Object)null, new Object[] {var0});
                }
                catch (Exception var2)
                {
                    ;
                }
            }
        }
    }

    private static void findCCTurtle()
    {
        if (!ccTurtleSearched)
        {
            try
            {
                ccTurtle = Class.forName("dan200.turtle.shared.CCTurtle");
                ccTurtle_registerTurtleUpgrade = findCCTurtleMethod("registerTurtleUpgrade", new Class[] {ITurtleUpgrade.class});
            }
            catch (ClassNotFoundException var4)
            {
                System.out.println("ComputerCraft: CCTurtle not found.");
            }
            finally
            {
                ccTurtleSearched = true;
            }
        }
    }

    private static Method findCCTurtleMethod(String var0, Class[] var1)
    {
        try
        {
            return ccTurtle.getMethod(var0, var1);
        }
        catch (NoSuchMethodException var3)
        {
            System.out.println("ComputerCraft: CCTurtle method " + var0 + " not found.");
            return null;
        }
    }
}
