package dan200.turtle.api;

import net.minecraft.server.ItemStack;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public interface ITurtleAccess
{
    World getWorld();

    Vec3D getPosition();

    int getFacingDir();

    int getInventorySize();

    int getSelectedSlot();

    ItemStack getSlotContents(int var1);

    void setSlotContents(int var1, ItemStack var2);

    boolean storeItemStack(ItemStack var1);

    boolean dropItemStack(ItemStack var1, int var2);

    boolean deployWithItemStack(ItemStack var1, int var2);

    boolean attackWithItemStack(ItemStack var1, int var2, float var3);

    int getFuelLevel();

    boolean refuelWithItemStack(ItemStack var1);

    boolean consumeFuel(int var1);

    int issueCommand(ITurtleCommandHandler var1);

    ITurtleUpgrade getUpgrade(TurtleSide var1);

    ITurtlePeripheral getPeripheral(TurtleSide var1);
}
