package immibis.core.api.porting;

import java.io.File;

import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Packet250CustomPayload;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public abstract class SidedProxy {
	public static SidedProxy instance;
	
	public abstract File getMinecraftDir();
	public abstract void addLocalization(String key, String value);
	public abstract void sendChat(String msg, EntityPlayer player);
	public abstract double getPlayerReach(EntityPlayer ply);
	public abstract EntityPlayer getThePlayer();
	public abstract int getUniqueBlockModelID(String renderClass, boolean b);
	public abstract boolean isOp(String player);
	public abstract void preloadTexture(String texfile);
	public abstract void registerTileEntity(Class<? extends TileEntity> clazz, String id, String rclass);
	public abstract boolean isWorldCurrent(World w);
	public abstract void registerItemRenderer(int itemID, String renderClassName);
	public abstract void registerServerPacketHandler(String channel, IServerPacketHandler handler);
	public abstract void registerClientPacketHandler(String channel, IClientPacketHandler handler);
	public abstract void sendPacket(Packet250CustomPayload wrap, EntityPlayer player);
	public abstract void setGuiHandler(PortableBaseMod mod, PortableGuiHandler handler);
	
	// Note: isClient and isServer may both be true for the same entity (in non-joined SSP)
	public abstract boolean isClient(Entity e);
	public abstract boolean isServer(Entity e);
	
	public abstract boolean isDedicatedServer();
}
