package immibis.core.api.porting;

import net.minecraft.src.Container;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Slot;
/* $if bukkit$
import net.minecraft.src.EntityPlayerMP;
$endif$ */
import net.minecraft.src.IInventory;

public class PortableContainer extends Container {
	
	protected EntityPlayer player;
	protected IInventory inv;
	
	/* $if mc >= 1.3$ */
	protected void addSlot(Slot s) {addSlotToContainer(s);}
	/* $endif$ */
	
	public PortableContainer(EntityPlayer player, IInventory inv) {
		this.player = player;
		this.inv = inv;
	}

	@Override
	public final boolean canInteractWith(EntityPlayer var1) {
		return inv.isUseableByPlayer(var1);
	}

}
