package mods.immibis.core.api;

import mods.immibis.core.api.crossmod.ICrossModBC;
import mods.immibis.core.api.crossmod.ICrossModIC2;
import mods.immibis.core.api.multipart.IMultipartSystem;
import mods.immibis.core.api.net.INetworkingManager;

/**
 * Contains methods to get instances of various API interfaces.
 * 
 * Mods using any APIs should specify "after:ImmibisCore" in their dependency list, so that
 * if the mod includes an outdated API then the newer one will take precedence.
 */
public final class APILocator {
	
	@SuppressWarnings("unchecked")
	private static <T> T getField(String name) {
		try {
			return (T)Class.forName("mods.immibis.core.ImmibisCore").getField(name).get(null);
		} catch(ClassNotFoundException e) {
			return null;
		} catch(RuntimeException e) {
			throw e;
		} catch(Exception e) {
			throw (AssertionError)new AssertionError("Should not happen").initCause(e);
		}
	}
	
	/**
	 * Returns the ID allocator interface, used to request block and item IDs
	 * and add recipes.
	 * 
	 * Null if Immibis Core is not installed.
	 */
	public static IIDAllocator getIDAllocator() {
		return getField("idAllocator");
	}
	
	/**
	 * Returns the networking manager interface, used to send and listen
	 * for packets.
	 * 
	 * Null if Immibis Core is not installed.
	 */
	public static INetworkingManager getNetManager() {
		return getField("networkingManager");
	}
	
	/**
	 * Returns the cross-mod interface for IC2.
	 */
	public static ICrossModIC2 getCrossModIC2() {
		return getField("crossModIC2");
	}

	/**
	 * Returns the cross-mod interface for Buildcraft.
	 */
	public static ICrossModBC getCrossModBC() {
		return getField("crossModBC");
	}

	/**
	 * Returns the (undocumented) multipart system interface.
	 */
	public static IMultipartSystem getMultipartSystem() {
		return getField("multipartSystem");
	}
}
